/**
 * Project Name:activity-center-biz File Name:GameCenterShieldServiceImpl.java Package
 * Name:cn.com.duiba.activity.center.biz.service.gamecenter.impl Date:2016年10月20日下午3:04:22 Copyright (c) 2016,
 * duiba.com.cn All Rights Reserved.
 */

package cn.com.duiba.activity.center.biz.service.gamecenter.impl;

import java.util.List;
import java.util.Map;

import javax.annotation.Resource;

import org.springframework.stereotype.Service;

import cn.com.duiba.activity.center.api.dto.gamecenter.ShieldItemDto;
import cn.com.duiba.activity.center.biz.dao.gamecenter.ActivityShieldDao;
import cn.com.duiba.activity.center.biz.entity.gamecenter.ActivityShieldEntity;
import cn.com.duiba.activity.center.biz.service.gamecenter.ActivityShieldService;
import cn.com.duiba.wolf.utils.BeanUtils;

/**
 * ClassName:GameCenterShieldServiceImpl <br/>
 * Function: TODO ADD FUNCTION. <br/>
 * Reason: TODO ADD REASON. <br/>
 * Date: 2016年10月20日 下午3:04:22 <br/>
 * 
 * @author Zhuzhiyong
 * @version
 * @since JDK 1.6
 * @see
 */
@Service
public class ActivityShieldServiceImpl implements ActivityShieldService {

    @Resource
    private ActivityShieldDao gameCenterShieldDao;

    @Override
    public ShieldItemDto find(Long id) {
        ActivityShieldEntity activityShieldEntity = gameCenterShieldDao.find(id);
        return BeanUtils.copy(activityShieldEntity, ShieldItemDto.class);
    }

    @Override
    public List<ShieldItemDto> findShieldList(Map<String, Object> paramMap) {
        return BeanUtils.copyList(gameCenterShieldDao.findShieldList(paramMap), ShieldItemDto.class);
    }

    @Override
    public Integer countShield(Map<String, Object> paramMap) {

        return gameCenterShieldDao.countShield(paramMap);
    }

    @Override
    public ShieldItemDto findShield(Long appId, Integer activityType, Long activityId) {
        ActivityShieldEntity activityShieldEntity = gameCenterShieldDao.findShield(appId, activityType, activityId);
        return BeanUtils.copy(activityShieldEntity, ShieldItemDto.class);
    }

    @Override
    public Long addShield(ShieldItemDto shieldItemDto) {
        return gameCenterShieldDao.insert(BeanUtils.copy(shieldItemDto, ActivityShieldEntity.class));
    }

    @Override
    public Boolean removeShield(Long shieldId) {
        return gameCenterShieldDao.delete(shieldId) == 1;
    }
}
