package cn.com.duiba.activity.center.biz.service.guess.impl;

import cn.com.duiba.activity.center.api.dto.guess.DuibaGuessBrickDto;
import cn.com.duiba.activity.center.biz.dao.guess.DuibaGuessBrickDao;
import cn.com.duiba.activity.center.biz.entity.guess.DuibaGuessBrickEntity;
import cn.com.duiba.activity.center.biz.service.guess.DuibaGuessBrickService;
import cn.com.duiba.wolf.utils.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * Created by yansen on 16/7/18.
 */
@Service
public class DuibaGuessBrickServiceImpl implements DuibaGuessBrickService {

    @Autowired
    private DuibaGuessBrickDao duibaGuessBrickDao;

    @Override
    public DuibaGuessBrickDto find(Long id) {
        return BeanUtils.copy(duibaGuessBrickDao.find(id),DuibaGuessBrickDto.class);
    }

    @Override
    public String getBrickContentById(Long id) {
        return duibaGuessBrickDao.getBrickContentById(id);
    }

    @Override
    public DuibaGuessBrickDto findNoContent(Long id) {
        return BeanUtils.copy(duibaGuessBrickDao.findNoContent(id),DuibaGuessBrickDto.class);
    }

    @Override
    public String getBrickPrizeContentById(Long id) {
        return duibaGuessBrickDao.getBrickContentById(id);
    }


    @Override
    public void insert(DuibaGuessBrickDto duibaGuessBrick) {
        DuibaGuessBrickEntity entity=BeanUtils.copy(duibaGuessBrick,DuibaGuessBrickEntity.class);
        duibaGuessBrickDao.insert(entity);
        duibaGuessBrick.setId(entity.getId());
    }

    @Override
    public void update4Admin(Long id, String title, String content, String prizeContent, String md5) {
        duibaGuessBrickDao.update4Admin(id,title,content,prizeContent,md5);
    }

    @Override
    public DuibaGuessBrickDto findByTitle(String title) {
        return BeanUtils.copy(duibaGuessBrickDao.findByTitle(title),DuibaGuessBrickDto.class);
    }

    @Override
    public void open(Long id) {
        duibaGuessBrickDao.open(id);
    }

    @Override
    public void disable(Long id) {
        duibaGuessBrickDao.disable(id);
    }

    @Override
    public List<DuibaGuessBrickDto> findPage(Integer offset, Integer max) {
        return BeanUtils.copyList(duibaGuessBrickDao.findPage(offset,max),DuibaGuessBrickDto.class);
    }

    @Override
    public Long findPageCount() {
        return duibaGuessBrickDao.findPageCount();
    }

    @Override
    public List<DuibaGuessBrickDto> findAll() {
        return BeanUtils.copyList(duibaGuessBrickDao.findAll(),DuibaGuessBrickDto.class);
    }
}
