package cn.com.duiba.activity.center.biz.service.guess.impl;

import cn.com.duiba.activity.center.biz.dao.guess.GuessOrdersStatusChangeDao;
import cn.com.duiba.activity.center.biz.kafka.GuessMQSend;
import cn.com.duiba.activity.center.biz.service.guess.GuessOrdersStatusChangeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * Created by yansen on 16/7/18.
 */
@Service
public class GuessOrdersStatusChangeServiceImpl implements GuessOrdersStatusChangeService{

    @Autowired
    private GuessMQSend guessMQSend;

    @Autowired
    private GuessOrdersStatusChangeDao guessOrdersStatusChangeDao;

    @Override
    public int updateStatusToSuccess(Long consumerId, Long guessOrderId, Long guessOrderExtraId) {
        int ret = guessOrdersStatusChangeDao.updateStatusToSuccess(consumerId,guessOrderId,guessOrderExtraId);
        if(ret==1){
            guessMQSend.guessSendDataSync(consumerId, guessOrderId);
        }
        return ret;
    }

    @Override
    public int updateStatusToFail(Long consumerId, Long guessOrderId, String error4admin, String error4developer, String error4consumer) {
        int ret = guessOrdersStatusChangeDao.updateStatusToFail(consumerId,guessOrderId,error4admin,error4developer,error4consumer);
        if(ret==1){
            guessMQSend.guessSendDataSync(consumerId, guessOrderId);
        }
        return ret;
    }

    @Override
    public int updateExchangeStatusToWaitOpen(Long consumerId, Long guessOrderId) {
        int ret = guessOrdersStatusChangeDao.updateExchangeStatusToWaitOpen(consumerId,guessOrderId);
        if(ret==1){
            guessMQSend.guessSendDataSync(consumerId, guessOrderId);
        }
        return ret;
    }

    @Override
    public int updateExchangeStatusToWaitOpenAndExtraId(Long consumerId, Long guessOrderId, Long guessOrderExtraId) {
        int ret = guessOrdersStatusChangeDao.updateExchangeStatusToWaitOpenAndExtraId(consumerId,guessOrderId,guessOrderExtraId);
        if(ret==1){
            guessMQSend.guessSendDataSync(consumerId, guessOrderId);
        }
        return ret;
    }

    @Override
    public int updateExchangeStatusToWait(Long consumerId, Long gameOrderId, Long itemId, Long appItemId, Long prizeId, String prizeType, String prizeName, String prizeFacePrice, Long couponId) {
        int ret = guessOrdersStatusChangeDao.updateExchangeStatusToWait(consumerId,gameOrderId,itemId,appItemId,prizeId,prizeType,prizeName,prizeFacePrice,couponId);
        if(ret==1){
            guessMQSend.guessSendDataSync(consumerId, gameOrderId);
        }
        return ret;
    }

    @Override
    public int updateExchangeStatusToFail(Long consumerId, Long gameOrderId, String error4admin, String error4developer, String error4consumer) {
        int ret = guessOrdersStatusChangeDao.updateExchangeStatusToFail(consumerId,gameOrderId,error4admin,error4developer,error4consumer);
        if(ret==1){
            guessMQSend.guessSendDataSync(consumerId, gameOrderId);
        }
        return ret;
    }

    @Override
    public int doTakePrize(Long consumerId, Long gameOrderId) {
        int ret = guessOrdersStatusChangeDao.doTakePrize(consumerId,gameOrderId);
        if(ret==1){
            guessMQSend.guessSendDataSync(consumerId, gameOrderId);
        }
        return ret;
    }

    @Override
    public int rollbackTakePrize(Long consumerId, Long gameOrderId) {
        int ret = guessOrdersStatusChangeDao.rollbackTakePrize(consumerId,gameOrderId);
        if(ret==1){
            guessMQSend.guessSendDataSync(consumerId, gameOrderId);
        }
        return ret;
    }

    @Override
    public int updateManualOpenPrizeExchangeStatusToWait(Long consumerId, Long gameOrderId, Long itemId, Long appItemId, Long prizeId, String prizeType, String prizeName, String prizeFacePrice, Long couponId) {
        int ret = guessOrdersStatusChangeDao.updateManualOpenPrizeExchangeStatusToWait(consumerId,gameOrderId,itemId,appItemId,prizeId,prizeType,prizeName,prizeFacePrice,couponId);
        if(ret==1){
            guessMQSend.guessSendDataSync(consumerId, gameOrderId);
        }
        return ret;
    }

    @Override
    public int updateIsGivePrize(Long consumerId, Long id, int b) {
        int ret = guessOrdersStatusChangeDao.updateIsGivePrize(consumerId,id,b);
        if(ret==1){
            guessMQSend.guessSendDataSync(consumerId, id);
        }
        return ret;
    }

    /**
     * 修改订单领奖状态为过期失效
     *
     * @param consumerId
     * @param id
     * @param error4admin
     * @param error4developer
     * @param error4consumer
     */
    @Override
    public int updateExchangeStatusToOverdue(Long consumerId, long id, String error4admin, String error4developer, String error4consumer) {
        int ret = guessOrdersStatusChangeDao.updateExchangeStatusToOverdue(consumerId,id,error4admin,error4developer,error4consumer);
        guessMQSend.guessSendDataSync(consumerId, id);//迁移前即没判断ret值
        return ret;
    }

    @Override
    public int updateStatusToConsumeSuccess(Long consumerId, Long gameOrderId) {
        int ret = guessOrdersStatusChangeDao.updateStatusToConsumeSuccess(consumerId,gameOrderId);
        if(ret==1){
            guessMQSend.guessSendDataSync(consumerId, gameOrderId);
        }
        return ret;
    }

    @Override
    public int updateExchangeStatusToWaitOpenAndExtraIdForLuck(Long consumerId, Long gameOrderId, Long guessOrderExtraId) {
        int ret = guessOrdersStatusChangeDao.updateExchangeStatusToWaitOpenAndExtraIdForLuck(consumerId,gameOrderId,guessOrderExtraId);
        if(ret==1){
            guessMQSend.guessSendDataSync(consumerId, gameOrderId);
        }
        return ret;
    }
}
