package cn.com.duiba.activity.center.biz.service.impl;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.activity.center.biz.service.GoodsService;
import cn.com.duiba.dcommons.enums.GoodsTypeEnum;
import cn.com.duiba.goods.center.api.remoteservice.dto.GoodsCouponDto;
import cn.com.duiba.goods.center.api.remoteservice.front.RemoteGoodsCouponService;
import cn.com.duiba.service.domain.dataobject.CouponDO;
import cn.com.duiba.service.domain.dataobject.ItemDO;
import cn.com.duiba.service.domain.vo.ItemKey;
import cn.com.duiba.service.exception.StatusException;
import cn.com.duiba.service.item.remoteservice.RemoteCouponFlowService;
import cn.com.duiba.wolf.dubbo.DubboResult;

@Service
public class GoodsServiceImpl implements GoodsService {

	@Autowired
	private RemoteCouponFlowService remoteCouponFlowService;
	@Autowired
	private RemoteGoodsCouponService remoteGoodsCouponService;

	@Override
	public boolean isGoodsCoupon(ItemKey itemKey) {
		if (itemKey.getItem() != null && itemKey.getItem().isOpTypeItem(ItemDO.OpTypeGoodsCoupon)) {
			return true;
		}
		if (itemKey.getAppItem() != null && itemKey.getAppItem().isOpTypeAppItem(ItemDO.OpTypeGoodsCoupon)) {
			return true;
		}
		return false;
	}

	@Override
	public CouponDO getOneCoupon(ItemKey itemKey, Long consumerId, String bizNum) throws Exception {
		if (isGoodsCoupon(itemKey)) {
			return getOneGoodsCoupon(itemKey, consumerId, bizNum);
		}
		return remoteCouponFlowService.getOneCoupon(itemKey);
	}

	@Override
	public void returnOneCoupon(long couponId, ItemKey itemKey, String bizNum) throws Exception{
		if (isGoodsCoupon(itemKey)) {
			DubboResult<Boolean> ret = remoteGoodsCouponService.rollbackCoupon(couponId, bizNum);
			if (!ret.getResult()) {
				throw new Exception("返回优惠券失败");
			}
		} else {
			remoteCouponFlowService.returnOneCoupon(couponId);
		}
	}

	private CouponDO getOneGoodsCoupon(ItemKey itemKey, Long consumerId, String bizNum) throws Exception {
		DubboResult<GoodsCouponDto> ret = null;
		Integer subType = null;
		Long itemId = null;
		Long appItemId = null;
		if (itemKey.getItem() != null && itemKey.getItem().isOpTypeItem(ItemDO.OpTypeGoodsCoupon)) {
			subType = itemKey.getItem().getSubType();
			itemId = itemKey.getItem().getId();
			ret = remoteGoodsCouponService.takeCoupon(GoodsTypeEnum.DUIBA, itemId, consumerId, bizNum);
		} else if (itemKey.getAppItem() != null && itemKey.getAppItem().isOpTypeAppItem(ItemDO.OpTypeGoodsCoupon)) {
			subType = itemKey.getAppItem().getSubType();
			appItemId = itemKey.getAppItem().getId();
			ret = remoteGoodsCouponService.takeCoupon(GoodsTypeEnum.APP, appItemId, consumerId, bizNum);
		}
		if (!ret.isSuccess()) {
			throw new Exception("商品中心获取优惠券失败!");
		}
		if (ret.getResult() == null) {
			throw new StatusException(0, "兑换券已兑完!");
		}
		GoodsCouponDto dto = ret.getResult();
		CouponDO coupon = new CouponDO();
		coupon.setId(dto.getGoodsCouponId());
		coupon.setBatchId(dto.getGoodsBatchId());
		if (subType == ItemDO.SubTypeCommon) {
			coupon.setCode(dto.getCode());
			coupon.setPassword(dto.getPassword());
		} else if (subType == ItemDO.SubTypeRepeat) {
			coupon.setCode(dto.getCode());
			coupon.setPassword(dto.getPassword());
		} else if (subType == ItemDO.SubTypeLink) {
			coupon.setCode(dto.getLink());
			coupon.setPassword(dto.getLink());
		}
		coupon.setAppItemId(appItemId);
		coupon.setItemId(itemId);
		return coupon;
	}

}
