package cn.com.duiba.activity.center.biz.service.luckbag;

import java.util.List;

import javax.servlet.http.HttpServletRequest;

import cn.com.duiba.activity.center.api.dto.plugin.ActivityPluginDto;
import cn.com.duiba.activity.center.api.dto.prize.ActivityPrizeOptionDto;

/**
 * 福袋请求
 * @author zp
 *
 */
public class LuckBagRequest {
	
	private String orderId;
	private Long consumerId;
	private Long operatingActivityId;
	private String ua;
	private String ip;
	private Long appId;
	private String tag;
	private Long orderExtraId;
	private String os;
	private List<ActivityPrizeOptionDto> options;
	private ActivityPluginDto pluDto;
	
    public List<ActivityPrizeOptionDto> getOptions() {
		return options;
	}

	public void setOptions(List<ActivityPrizeOptionDto> options) {
		this.options = options;
	}

	public ActivityPluginDto getPluDto() {
		return pluDto;
	}

	public void setPluDto(ActivityPluginDto pluDto) {
		this.pluDto = pluDto;
	}

	public String getOs() {
		return os;
	}

	public void setOs(String os) {
		this.os = os;
	}

	public String getTag() {
        return tag;
    }
    
    public void setTag(String tag) {
        this.tag = tag;
    }

    public String getOrderId() {
		return orderId;
	}

	public void setOrderId(String orderId) {
		this.orderId = orderId;
	}

	public Long getConsumerId() {
		return consumerId;
	}

	public void setConsumerId(Long consumerId) {
		this.consumerId = consumerId;
	}

	public Long getOperatingActivityId() {
		return operatingActivityId;
	}

	public void setOperatingActivityId(Long operatingActivityId) {
		this.operatingActivityId = operatingActivityId;
	}
	public String getUa() {
		return ua;
	}

	public void setUa(String ua) {
		this.ua = ua;
	}

	public String getIp() {
		return ip;
	}

	public void setIp(String ip) {
		this.ip = ip;
	}

	public Long getAppId() {
		return appId;
	}

	public void setAppId(Long appId) {
		this.appId = appId;
	}
	
    public Long getOrderExtraId() {
        return orderExtraId;
    }

    public void setOrderExtraId(Long orderExtraId) {
        this.orderExtraId = orderExtraId;
    }

	public static LuckBagRequest buildRequestData(String orderId,Long consumerId,Long operatingActivityId,Long appId,String ip,String ua, Long orderExtraId, String tag, String os,List<ActivityPrizeOptionDto> options, ActivityPluginDto pluDto){
		LuckBagRequest req = new LuckBagRequest();
		req.setConsumerId(consumerId);
		req.setOperatingActivityId(operatingActivityId);
		req.setOrderId(orderId);
		req.setAppId(appId);
		req.setIp(ip);
		req.setUa(ua);
		req.setTag(tag);
		req.setOrderExtraId(orderExtraId);
		req.setOs(os);
		req.setOptions(options);
		req.setPluDto(pluDto);
		return req;
	}

	/**
	 * 获取User-Agent
	 * @param request
	 * @return
	 */
	public static String getUserAgent(HttpServletRequest request){
		String ua=request.getHeader("User-Agent");
		if(ua==null){
			return "unknown";
		}
		ua=ua.toLowerCase();
		if(ua!=null){
			if(ua.contains("ipad")){
				return "IOS";
			}else if(ua.contains("iphone")){
				return "IOS";
			}else if(ua.contains("android")){
				return "Android";
			}else if(ua.contains("macintosh")){
				return "IOS";
			}
		}
		return "unknown";
	}
	
	/**
	 * 
	 * getUserAgent:获取User-Agent
	 * @author clemac
	 * @param ua
	 * @return
	 * @since JDK 1.6
	 */
    public static String getUserAgent(String ua){
        if(ua==null){
            return "unknown";
        }
        ua=ua.toLowerCase();
        if(ua!=null){
            if(ua.contains("ipad")){
                return "IOS";
            }else if(ua.contains("iphone")){
                return "IOS";
            }else if(ua.contains("android")){
                return "Android";
            }else if(ua.contains("macintosh")){
                return "IOS";
            }
        }
        return "unknown";
    }
}
