package cn.com.duiba.activity.center.biz.service.plugin;

import java.util.Date;
import java.util.List;
import java.util.Map;

import cn.com.duiba.activity.center.api.dto.plugin.ActivityPluginDto;

/** 
 * ClassName:ActivityPluginService.java <br/>
 * @author  Administrator 
 * @date 创建时间：2016年10月11日 下午4:20:10 
 * @version 1.0 
 * @since   JDK 1.6
 * @return  
 */
public interface ActivityPluginService {

	/**
	 * 插入插件活动配置项
	 * @param ActivityPluginDto 插件活动配置
	 */
	public ActivityPluginDto createActivityPluginInfo(ActivityPluginDto activityPluginDto);

	/**
	 * 编辑插件活动配置
	 * @param ActivityPluginDto 插件活动配置
	 */
	public Integer updateActivityPluginInfo(ActivityPluginDto activityPluginDto);

	/**
	 * 根据Id查询插件活动
	 * @param 签到编辑
	 * @return 操作结果
	 */
	public ActivityPluginDto findById(Long id);

	/**
	 * 根据Id开启插件活动配置
	 * @param id 签到ID
	 * @return 操作结果
	 */
	public Integer OpenStatus(Long id,Integer value);
	
	/**
	 * 查询插件活动list
	 * @param id 签到ID
	 * @return 操作结果
	 */
	public List<ActivityPluginDto> findActivityPluginInfoList(Map<String, Object> map);

	/**
	 * 查询插件活动满足条件的总条数
	 * @param map 
	 * @return 操作结果
	 */
	public Long findPageCount(Map<String, Object> paramMap);

	/**
	 * 删除插件活动
	 * @param id 签到ID
	 * @return 操作结果
	 */
	public Integer dellActivityPlugin(Long id);

	/**
	 * 修改自动下架时间
	 * @author liyang
	 * @param autoOffDate
	 * @param id
	 * @return
	 * @since JDK 1.6
	 */
	public int updateAutoOffDateNull(Date autoOffDate, Long id);

	/**
	 * 修改自动下架时间
	 * @author gey
	 * @return
	 * @since JDK 1.6
	 */
	public String createOrder(Long consumerId, String transfer, String ip,
			String description, String ua, String os, ActivityPluginDto pluDto);
}
