package cn.com.duiba.activity.center.biz.service.rob;

import cn.com.duiba.activity.center.api.dto.rob.category.RobBarCategoryRelationDto;
import cn.com.duiba.activity.center.biz.entity.robcategory.RobCategoryBarEntity;

import java.util.List;

/**
 * 功能描述:今日必抢分类栏service相关接口
 *
 * @author sunchangji
 * @date 2016/10/18
 */
public interface RobCategoryBarService {

    /**
     * 获取全部分类栏列表信息
     *
     * @return
     */
    List<RobCategoryBarEntity> getAllCategoryBarList();

    /**
     * 根据分类栏名称分页查询分类栏信息，
     * 如果分类栏名称为空则查询的是全部信息
     *
     * @param name     分类栏名称(模糊匹配)
     * @param offset   偏移量
     * @param pageSize 页距
     * @return
     */
    List<RobCategoryBarEntity> getPagByName(String name, Integer offset, Integer pageSize);

    /**
     * 根据分类栏name分页查询分类栏总记录数
     *
     * @param name 分类栏名称，不传查询全部记录数
     * @return
     */
    public Integer countByName(String name);

    /**
     * 根据分类栏id删除分类栏
     *
     * @param barId 分类栏id
     * @return
     */
    Boolean deleteBarById(Long barId);


    /**
     * 新增分类栏
     *
     * @param name         分类栏名称
     * @param relationDtos 分类栏对应的分类关联数据(分类id,排序值)
     * @return
     */
    Boolean insertRobCategoryBar(String name, List<RobBarCategoryRelationDto> relationDtos);

    /**
     * 根据分类栏id查询分类栏信息
     *
     * @param barId 分类id
     * @return
     */
    RobCategoryBarEntity getRobCategoryBarById(Long barId);

    /**
     * 根据分类栏id查询该分类栏下所有分类id，结果是按排序的
     *
     * @param barId 分类栏id
     * @return
     */
    List<Long> getRobCategoryIdsBarById(Long barId);

    /**
     * 更新分类栏
     *
     * @param barId        分类栏id
     * @param name         分类栏名称
     * @param relationDtos 关联分类数据
     * @return
     */
    Boolean updateCategoryBar(Long barId, String name, List<RobBarCategoryRelationDto> relationDtos);

}
