package cn.com.duiba.activity.center.biz.service.rob.impl;

import cn.com.duiba.activity.center.api.dto.rob.category.RobBarCategoryRelationDto;
import cn.com.duiba.activity.center.biz.dao.DsConstants;
import cn.com.duiba.activity.center.biz.dao.rob_category.RobBarCategoryRelationDao;
import cn.com.duiba.activity.center.biz.dao.rob_category.RobCategoryBarAppRelationDao;
import cn.com.duiba.activity.center.biz.dao.rob_category.RobCategoryBarDao;
import cn.com.duiba.activity.center.biz.entity.robcategory.RobCategoryBarEntity;
import cn.com.duiba.activity.center.biz.service.rob.RobCategoryBarService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * 功能描述:今日必抢分类栏service实现类
 *
 * @author sunchangji
 * @date 2016/10/18
 */
@Service
public class RobCategoryBarServiceImpl implements RobCategoryBarService {
    private static final Logger log = LoggerFactory.getLogger(RobCategoryBarServiceImpl.class);
    @Autowired
    private RobCategoryBarDao robCategoryBarDao;
    @Autowired
    private RobCategoryBarAppRelationDao robCategoryBarAppRelationDao;
    @Autowired
    private RobBarCategoryRelationDao robBarCategoryRelationDao;


    @Override
    public List<RobCategoryBarEntity> getAllCategoryBarList() {
        return robCategoryBarDao.getAllCategoryBarList();
    }

    @Override
    public List<RobCategoryBarEntity> getPagByName(String name, Integer offset, Integer pageSize) {
        if (offset == null || offset < 0) {
            offset = 0;
        }
        if (pageSize == null || pageSize < 1) {
            pageSize = 20;
        }
        return robCategoryBarDao.getPageByName(name, offset, pageSize);
    }

    @Override
    public Integer countByName(String name) {
        return robCategoryBarDao.countByName(name);
    }

    /**
     * 逻辑步骤：
     * 1.根据分类栏id删除分类栏与应用关联表相关数据
     * 2.根据分类栏id删除分类栏与分类关联表数据
     * 3.根据分类id删除分类栏数据
     * 4.把分类栏对应的app分类列表缓存置失效
     *
     * @param barId 分类栏id
     * @return
     */
    @Override
    public Boolean deleteBarById(Long barId) {
        if (barId.equals(1L)) {
            log.error("共享分类栏不能删除");
            return false;
        }
        transationDeleteByBarId(barId);
        return true;
    }

    @Override
    @Transactional(value = DsConstants.DATABASE_CREDITS_ACTIVITY)
    public Boolean insertRobCategoryBar(String name, List<RobBarCategoryRelationDto> relationDtos) {
        Long barId = robCategoryBarDao.insertRobCategoryBar(new RobCategoryBarEntity(name));
        if (barId == null || barId < 1)
            return false;
        if (!CollectionUtils.isEmpty(relationDtos)) {
            for (RobBarCategoryRelationDto robBarCategoryRelationDto : relationDtos) {
                robBarCategoryRelationDao.insertRobBar(barId, robBarCategoryRelationDto.getCategoryId(), robBarCategoryRelationDto.getPayload());
            }
        }
        return true;
    }

    @Override
    public RobCategoryBarEntity getRobCategoryBarById(Long barId) {
        return robCategoryBarDao.getById(barId);
    }

    public List<Long> getRobCategoryIdsBarById(Long barId) {
        List<Long> categoryIds = robBarCategoryRelationDao.getRobCategoryIdsByBarId(barId);
        if (categoryIds == null) {
            categoryIds = new ArrayList<>();
        }
        return categoryIds;
    }

    /**
     * 把3步删除放在一个事务中操作
     *
     * @param barId
     * @return
     */
    @Transactional(value = DsConstants.DATABASE_CREDITS_ACTIVITY)
    private void transationDeleteByBarId(Long barId) {
        robCategoryBarAppRelationDao.deleteByBarId(barId);
        robBarCategoryRelationDao.deleteByBarId(barId);
        robCategoryBarDao.deleteById(barId);
    }

    public Boolean updateCategoryBar(Long barId,String name, List<RobBarCategoryRelationDto> relationDtos){
        robCategoryBarDao.updateRobCategoryBar(barId,name);
        robBarCategoryRelationDao.deleteByBarId(barId);
        if(!CollectionUtils.isEmpty(relationDtos)){
            for(RobBarCategoryRelationDto robBarCategoryRelationDto : relationDtos){
                robBarCategoryRelationDao.insertRobBar(barId,robBarCategoryRelationDto.getCategoryId(),robBarCategoryRelationDto.getPayload());
            }

        }
        return true;

    }
}
