package cn.com.duiba.activity.center.biz.service.singlelottery.impl;

import cn.com.duiba.activity.center.api.dto.DeveloperActivityStatisticsDto;
import cn.com.duiba.activity.center.api.dto.singlelottery.SingleLotteryOrderDto;
import cn.com.duiba.activity.center.biz.dao.singlelottery.SingleLotteryOrderDao;
import cn.com.duiba.activity.center.biz.entity.singlelottery.SingleLotteryOrderEntity;
import cn.com.duiba.activity.center.biz.service.singlelottery.SingleLotteryOrderService;
import cn.com.duiba.wolf.utils.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * Created by yansen on 16/6/24.
 */
@Service
public class SingleLotteryOrderServiceImpl implements SingleLotteryOrderService {

    @Autowired
    private SingleLotteryOrderDao singleLotteryOrderDao;

    /**
     * 根据ID查询单品抽奖订单
     *
     * @param id
     */
    @Override
    public SingleLotteryOrderDto find(Long id) {
        return BeanUtils.copy(singleLotteryOrderDao.find(id),SingleLotteryOrderDto.class);
    }

    /**
     * 统计奖项用户中奖次数
     *
     * @param activityId
     * @param consumerId
     * @param optionType
     */
    @Override
    public Integer countByConsumerIdAndOptionType(Long activityId, Long consumerId, Integer optionType) {
        return singleLotteryOrderDao.countByConsumerIdAndOptionType(activityId,consumerId,optionType);
    }

    /**
     * 根据ID集合查询订单
     *
     * @param ids
     */
    @Override
    public List<SingleLotteryOrderDto> findAllByIds(List<Long> ids) {
        return BeanUtils.copyList(singleLotteryOrderDao.findAllByIds(ids),SingleLotteryOrderDto.class);
    }

    /**
     * 查询当前用户在当前活动当前APP的抽奖次数
     *
     * @param activityId
     * @param appId
     * @param consumerId
     */
    @Override
    public Integer findLotteryCountByComsumer(Long activityId, Long appId, Long consumerId) {
        return singleLotteryOrderDao.findLotteryCountByComsumer(activityId,appId,consumerId);
    }

    /**
     * 查询当天当前用户在当前活动当前APP的抽奖次数
     *
     * @param activityId
     * @param appId
     * @param consumerId
     * @param statTime
     * @param endTime
     */
    @Override
    public Integer findCountByComsumerTime(Long activityId, Long appId, Long consumerId, Date statTime, Date endTime) {
        return singleLotteryOrderDao.findCountByComsumerTime(activityId,appId,consumerId,statTime,endTime);
    }

    /**
     * 查询前台显示5条中奖名单
     *
     * @param activityId
     * @param appId
     */
    @Override
    public List<SingleLotteryOrderDto> findFrontLotteryList(Long activityId, Long appId) {
        return BeanUtils.copyList(singleLotteryOrderDao.findFrontLotteryList(activityId,appId),SingleLotteryOrderDto.class);
    }

    /**
     * 根据上游订单号查单
     *
     * @param appId
     * @param bizId
     */
    @Override
    public SingleLotteryOrderDto findByAppAndDeveloperBizId(Long appId, String bizId) {
        return BeanUtils.copy(singleLotteryOrderDao.findByAppAndDeveloperBizId(appId,bizId),SingleLotteryOrderDto.class);
    }

    /**
     * 根据订单ID查询订单信息
     *
     * @param ids
     */
    @Override
    public List<SingleLotteryOrderDto> findByIds(List<Long> ids) {
        return BeanUtils.copyList(singleLotteryOrderDao.findByIds(ids),SingleLotteryOrderDto.class);
    }

    /**
     * 根据主订单ID集合查询单品订单
     *
     * @param ids
     */
    @Override
    public List<SingleLotteryOrderDto> findByInOrderIds(List<Long> ids) {
        return BeanUtils.copyList(singleLotteryOrderDao.findByInOrderIds(ids),SingleLotteryOrderDto.class);
    }

    /**
     * 查询创建时间小于 PARAM的订单
     * 扫描24小时没有领奖的订单，查询较慢，待优化
     */
    @Override
    public List<SingleLotteryOrderDto> findAllByLtGmtCreateAndExchangeStatus() {
        return BeanUtils.copyList(singleLotteryOrderDao.findAllByLtGmtCreateAndExchangeStatus(),SingleLotteryOrderDto.class);
    }

    /**
     * 获取失败订单数
     *
     * @param operatingActivityIds
     */
    @Override
    public List<DeveloperActivityStatisticsDto> findFailCountByOperatingActivityIds(List<Long> operatingActivityIds) {
        return BeanUtils.copyList(singleLotteryOrderDao.findFailCountByOperatingActivityIds(operatingActivityIds),DeveloperActivityStatisticsDto.class);
    }

    /**
     * 单品抽奖订单分页
     *
     * @param paramMap
     */
    @Override
    public List<SingleLotteryOrderDto> findByLimit(Map<String, Object> paramMap) {
        return BeanUtils.copyList(singleLotteryOrderDao.findByLimit(paramMap),SingleLotteryOrderDto.class);
    }

    /**
     * 单品抽奖订单分页条数
     *
     * @param paramMap
     */
    @Override
    public Long findByCount(Map<String, Object> paramMap) {
        return singleLotteryOrderDao.findByCount(paramMap);
    }

    /**
     * 根据奖项类型查询中奖人数
     *
     * @param operatingActivityIds
     * @param statTime
     * @param endTime
     * @param optionType
     */
    @Override
    public Integer countWintimesByOptionType(List<Long> operatingActivityIds, Date statTime, Date endTime, Integer optionType) {
        return singleLotteryOrderDao.countWintimesByOptionType(operatingActivityIds,statTime,endTime,optionType);
    }

    /**
     * 根据开发者单品活动ID列表得到活动ID对中大奖人数的Map
     *
     * @param operatingActivityIds
     */
    @Override
    public List<SingleLotteryOrderDto> getWinningListByOperatingActivityIds(Collection<Long> operatingActivityIds) {
        return BeanUtils.copyList(singleLotteryOrderDao.getWinningListByOperatingActivityIds(operatingActivityIds),SingleLotteryOrderDto.class);
    }

    /**
     * 修改订单领奖状态为失败
     *
     * @param id
     * @param error4admin
     * @param error4developer
     * @param error4consumer
     */
    @Override
    public int updateExchangeStatusToFail(long id, String error4admin, String error4developer, String error4consumer) {
        return singleLotteryOrderDao.updateExchangeStatusToFail(id,error4admin,error4developer,error4consumer);
    }

    /**
     * 修改订单领奖状态为过期失效
     *
     * @param id
     * @param error4admin
     * @param error4developer
     * @param error4consumer
     */
    @Override
    public int updateExchangeStatusToOverdue(long id, String error4admin, String error4developer, String error4consumer) {
        return singleLotteryOrderDao.updateExchangeStatusToOverdue(id,error4admin,error4developer,error4consumer);
    }

    /**
     * 修改订单状态成功，领奖状态待领奖
     *
     * @param id
     */
    @Override
    public int updateStatusToSuccess(long id) {
        return singleLotteryOrderDao.updateStatusToSuccess(id);
    }

    /**
     * 修改订单状态失败
     *
     * @param id
     * @param error4admin
     * @param error4developer
     * @param error4consumer
     */
    @Override
    public int updateStatusToFail(long id, String error4admin, String error4developer, String error4consumer) {
        return singleLotteryOrderDao.updateStatusToFail(id,error4admin,error4developer,error4consumer);
    }

    /**
     * 订单抽奖失败，修改为未中奖
     *
     * @param id
     */
    @Override
    public int updatePrizeTypeToThanks(long id) {
        return singleLotteryOrderDao.updatePrizeTypeToThanks(id);
    }

    /**
     * 处理领奖
     *
     * @param id
     */
    @Override
    public Integer doTakePrize(Long id) {
        return singleLotteryOrderDao.doTakePrize(id);
    }

    /**
     * 领奖创建主订单失败回滚领奖
     *
     * @param id
     */
    @Override
    public Integer rollbackTakePrize(Long id) {
        return singleLotteryOrderDao.rollbackTakePrize(id);
    }

    /**
     * 修改订单抽奖结果
     *
     * @param id
     * @param appItemId
     * @param itemId
     * @param prizeName
     * @param prizeType
     * @param prizeDegree
     * @param prizeFacePrice
     * @param optionType
     * @param couponId
     */
    @Override
    public Integer updateLotteryResult(Long id, Long appItemId, Long itemId, String prizeName, String prizeType, String prizeDegree, Integer prizeFacePrice, Integer optionType, Long couponId) {
        return singleLotteryOrderDao.updateLotteryResult(id,appItemId,itemId,prizeName,prizeType,prizeDegree,prizeFacePrice,optionType,couponId);
    }

    /**
     * 修改开发者订单号
     *
     * @param id
     * @param bizId
     */
    @Override
    public int updateDeveloperBizId(long id, String bizId) {
        return singleLotteryOrderDao.updateDeveloperBizId(id,bizId);
    }

    /**
     * 修改主订单ID
     *
     * @param id
     * @param orderId
     */
    @Override
    public int updateMainOrderId(long id, Long orderId) {
        return singleLotteryOrderDao.updateMainOrderId(id,orderId);
    }

    /**
     * 新增单品抽奖订单
     *
     * @param singleLotteryOrderDO
     */
    @Override
    public void insert(SingleLotteryOrderDto singleLotteryOrderDO) {
        SingleLotteryOrderEntity entity=new SingleLotteryOrderEntity(true);
        BeanUtils.copy(singleLotteryOrderDO,entity);
        singleLotteryOrderDao.insert(entity);
        singleLotteryOrderDO.setId(entity.getId());
    }
}
