/**
 * Project Name:activity-center-biz
 * File Name:ItemKeyStockServcie.java
 * Package Name:cn.com.duiba.activity.center.biz.tools
 * Date:2016年7月29日下午1:43:27
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.activity.center.biz.tools.service;

import java.util.Date;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.service.domain.dataobject.CouponBatchDO;
import cn.com.duiba.service.domain.dataobject.ItemDO;
import cn.com.duiba.service.domain.vo.ItemKey;
import cn.com.duiba.service.item.remoteservice.RemoteCouponService;
import cn.com.duiba.service.item.remoteservice.RemoteItemAppSpecifyService;
import cn.com.duiba.service.remoteservice.RemotePreStockService;

/**
 * ClassName:ItemKeyStockServcie <br/>
 * Function: TODO ADD FUNCTION. <br/>
 * Reason:	 TODO ADD REASON. <br/>
 * Date:     2016年7月29日 下午1:43:27 <br/>
 * @author   zp
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
@Service
public class ItemKeyStockServcie {
    
    @Autowired
    private RemoteCouponService remoteCouponService;
    @Autowired
    private RemoteItemAppSpecifyService remoteItemAppSpecifyService;
    @Autowired
    private RemotePreStockService remotePreStockService;

    public Integer findRemaining(ItemKey itemKey){
    	return remotePreStockService.findRemaining(itemKey);
    }
    
    public boolean couponBatchCheck(ItemKey itemKey){
        // 优惠券批次校验
        if (ItemDO.TypeCoupon.equals(itemKey.getItemType())) {
            if (itemKey.isItemMode() || itemKey.isDuibaAppItemMode()) {
                if (itemKey.getItem().getValidEndDate() != null && new Date().after(itemKey.getItem().getValidEndDate())) {
                    return false;
                }
                if (itemKey.getItem().getAutoOffDate() != null && new Date().after(itemKey.getItem().getAutoOffDate())) {
                    return false;
                }
            } else if (itemKey.isSelfAppItemMode()) {
                if (itemKey.getAppItem().getValidEndDate() != null && new Date().after(itemKey.getAppItem().getValidEndDate())) {
                    return false;
                }
                if (itemKey.getAppItem().getAutoOffDate() != null && new Date().after(itemKey.getAppItem().getAutoOffDate())) {
                    return false;
                }
            }
        }
        return true;
    }
}

