package cn.com.duiba.activity.center.biz.bo.game;

import cn.com.duiba.activity.center.api.dto.game.DuibaQuestionAnswerOptionsDto;
import cn.com.duiba.activity.center.api.dto.game.DuibaQuestionStockDto;
import cn.com.duiba.activity.center.biz.service.game.DuibaQuestionAnswerOptionsService;
import cn.com.duiba.activity.center.biz.service.game.DuibaQuestionStockService;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by wenqi.huang on 16/6/1.
 */
@Service
public class DuibaQuestionAnswerOptionsBo {
    @Resource
    private DuibaQuestionAnswerOptionsService duibaQuestionAnswerOptionsService;
    @Resource
    private DuibaQuestionStockService duibaQuestionStockDAO;

    //from DuibaQuestionAnswerOptionsServiceImpl in manager

    public List<DuibaQuestionAnswerOptionsDto> findByQuestionAnswerId(Long questionAnswerId) {
        List<DuibaQuestionAnswerOptionsDto> optionList = duibaQuestionAnswerOptionsService.findOptionsByQuestionId(questionAnswerId);
        List<Long> optionIds = new ArrayList<Long>();
        for (int i = 0; i < optionList.size(); i++) {
            optionIds.add(optionList.get(i).getId());
        }
        if(!optionIds.isEmpty()) {
            List<DuibaQuestionStockDto> stocks = duibaQuestionStockDAO.findByQuestionOptionIds(optionIds);
            Map<Long, DuibaQuestionStockDto> stockMap = new HashMap<Long, DuibaQuestionStockDto>();
            for (int i = 0; i < stocks.size(); i++) {
                stockMap.put(stocks.get(i).getQuestionOptionId(), stocks.get(i));
            }
            for (int i = 0; i < optionList.size(); i++) {
                DuibaQuestionAnswerOptionsDto optionDo = optionList.get(i);
                DuibaQuestionStockDto duibaQuestionStockDto = stockMap.get(optionDo.getId());
                if(null != duibaQuestionStockDto) {
                    optionDo.setOptionCount(duibaQuestionStockDto.getStock());
                }
            }
        }
        return optionList;
    }

}
