package cn.com.duiba.activity.center.biz.dao.elasticgifts;

import cn.com.duiba.activity.center.biz.entity.elasticgifts.ElasticGiftsEntity;

import java.util.List;

/**
 * 弹层活动接口
 */
public interface ElasticGiftsDao {

    /**
     * 获取分页列表
     * @param offset
     * @param max
     * @param bizCode
     * @param elasticGiftsId
     * @param title4admin
     * @return
     */
    List<ElasticGiftsEntity> findPage(int offset, int max, Integer bizCode, Long elasticGiftsId, String title4admin);

    /**
     * 获取分页总个数
     * @param bizCode
     * @param elasticGiftsId
     * @param title4admin
     * @return
     */
    Integer findPageCount(Integer bizCode, Long elasticGiftsId, String title4admin);

    /**
     * 更新状态
     * @param id
     * @param targetStatus
     * @return
     */
    int updateStatus(Long id, Integer targetStatus);

    /**
     * 删除
     * @param id
     * @return
     */
    int delete(Long id);

    /**
     * 插入
     * @param entity
     * @return
     */
    int insert(ElasticGiftsEntity entity);

    /**
     * 更新
     * @param entity
     * @return
     */
    int update(ElasticGiftsEntity entity);

    /**
     * 根据 id 查询
     * @param id
     * @return
     */
    ElasticGiftsEntity find(Long id);

    /**
     * 根据 id 和 bizcode 查询
     * @param id
     * @param bizCode
     * @return
     */
    ElasticGiftsEntity findByIdAndBizCode(Long id, Integer bizCode);

    /**
     * 根据标题和 bizCode 模糊查询获取list
     * @param text
     * @return
     */
    List<ElasticGiftsEntity> findAllByTitle4adminAndBizCode(String text, Integer bizCode);

}
