/**
 * Project Name:activity-center-biz File Name:ActivityShieldDaoImpl.java Package
 * Name:cn.com.duiba.activity.center.biz.dao.gamecenter.impl Date:2016年10月20日上午11:35:40 Copyright (c) 2016, duiba.com.cn
 * All Rights Reserved.
 */

package cn.com.duiba.activity.center.biz.dao.gamecenter.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.stereotype.Repository;

import cn.com.duiba.activity.center.biz.dao.ActivityBaseDao;
import cn.com.duiba.activity.center.biz.dao.DatabaseSchema;
import cn.com.duiba.activity.center.biz.dao.gamecenter.ActivityShieldDao;
import cn.com.duiba.activity.center.biz.entity.gamecenter.ActivityShieldEntity;

/**
 * ClassName:ActivityShieldDaoImpl <br/>
 * Function: TODO ADD FUNCTION. <br/>
 * Reason: TODO ADD REASON. <br/>
 * Date: 2016年10月20日 上午11:35:40 <br/>
 * 
 * @author Zhuzhiyong
 * @version
 * @since JDK 1.6
 * @see
 */
@Repository("activityShieldDao")
public class ActivityShieldDaoImpl extends ActivityBaseDao implements ActivityShieldDao {

    @Override
    protected DatabaseSchema chooseSchema() {
        return DatabaseSchema.CREDITS_GAME;
    }

    @Override
    public Long insert(ActivityShieldEntity entity) {
        insert("insert", entity);
        return entity.getId();
    }

    @Override
    public int delete(Long id) {
        return delete("delete", id);
    }

    @Override
    public ActivityShieldEntity find(Long id) {
        return selectOne("find", id);
    }

    @Override
    public ActivityShieldEntity findShield(Long appId, Integer activityType, Long activityId) {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("appId", appId);
        params.put("activityType", activityType);
        params.put("activityId", activityId);
        return selectOne("findShield", params);
    }

    @Override
    public List<ActivityShieldEntity> findShieldList(Map<String, Object> paramMap) {
        return selectList("findShieldList", paramMap);
    }

    @Override
    public Integer countShield(Map<String, Object> paramMap) {
        return selectOne("countShield", paramMap);
    }

}
