package cn.com.duiba.activity.center.biz.dao.guess.impl;

import cn.com.duiba.activity.center.biz.dao.ActivityBaseDao;
import cn.com.duiba.activity.center.biz.dao.DatabaseSchema;
import cn.com.duiba.activity.center.biz.dao.guess.DuibaGuessDao;
import cn.com.duiba.activity.center.biz.entity.AddActivityEntity;
import cn.com.duiba.activity.center.biz.entity.guess.DuibaGuessEntity;
import org.springframework.stereotype.Repository;

import java.util.*;

@Repository
public class DuibaGuessDaoImpl extends ActivityBaseDao implements DuibaGuessDao {

	@Override
	public DuibaGuessEntity find(Long id) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("id", id);
		return selectOne("find", paramMap);
	}

	@Override
	public List<DuibaGuessEntity> findByPage(Integer offset, Integer max, String title, Integer id) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("offset", offset);
		paramMap.put("max", max);
		paramMap.put("title", title);
	    paramMap.put("id", id);
		return selectList("findByPage", paramMap);
	}
	
	@Override
	public Long findPageCount(String title, Integer id) {
	    Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("title", title);
        paramMap.put("id", id);
		return selectOne("findPageCount",paramMap);
	}

	@Override
	public int updateStatus(Long id, int status) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("id", id);
		paramMap.put("status", status);
		return update("updateStatus", paramMap);
	}

	@Override
	public int delete(Long id) {
		return update("delete", id);
	}

	@Override
	public void insert(DuibaGuessEntity DuibaGuessEntity) {
		insert("insert",DuibaGuessEntity);
	}

	@Override
	public int updateInfoForm(DuibaGuessEntity DuibaGuessEntity) {
		return update("updateInfoForm",DuibaGuessEntity);
	}

	@Override
	public void updateSwitches(Long id, Integer switches) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("id", id);
		paramMap.put("switches", switches);
		update("updateSwitches", paramMap);
	}
	
	public int updateAutoOffDateNull(Date autoOffDate, Long id){
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("id", id);
		paramMap.put("autoOffDate", autoOffDate);
		return update("updateAutoOffDateNull", paramMap);
	}

    @Override
    public void updateOpenWinning(Long id, String luckNum, Long rightSelectionId, Integer isAccurate) {
        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("id", id);
        paramMap.put("luckNum", luckNum);
        paramMap.put("rightSelectionId", rightSelectionId);
        paramMap.put("isAccurate", isAccurate);
        update("updateOpenWinning", paramMap);
    }

	@Override
	public List<DuibaGuessEntity> findAllByIds(List<Long> ids) {
		if(ids==null || ids.isEmpty()){
			return Collections.emptyList();
		}
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("ids", ids);
		return selectList("findAllByIds", paramMap);
	}

	@Override
	public List<AddActivityEntity> findAllGuess(Long appId) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("appId", appId);
		return selectList("findAllGuess", paramMap);
	}

	@Override
	public int updateOpenPrize(Long id) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("id", id);
		return update("updateOpenPrize", paramMap);
	}

	@Override
	public List<DuibaGuessEntity> findAutoOff() {
		Calendar cal1 = Calendar.getInstance();
		cal1.setTime(new Date());
		cal1.add(Calendar.DATE, -1);
		Date startTime = cal1.getTime();

		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("startTime", startTime);
		paramMap.put("endTime", new Date());
		return selectList("findAutoOff", paramMap);
	}
	
	@Override
	protected DatabaseSchema chooseSchema() {
		return DatabaseSchema.GUESS;
	}
}
