package cn.com.duiba.activity.center.biz.dao.guess.impl;


import cn.com.duiba.activity.center.biz.dao.ActivityBaseDao;
import cn.com.duiba.activity.center.biz.dao.DatabaseSchema;
import cn.com.duiba.activity.center.biz.dao.guess.DuibaGuessSelectionsDao;
import cn.com.duiba.activity.center.biz.entity.guess.DuibaGuessSelectionsEntity;
import org.springframework.stereotype.Repository;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Repository("duibaGuessSelectionsDAO")
public class DuibaGuessSelectionsDaoImpl extends ActivityBaseDao implements DuibaGuessSelectionsDao {

	@Override
	public DuibaGuessSelectionsEntity find(Long id) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("id", id);
		return selectOne("find", paramMap);
	}

	@Override
	public void insert(DuibaGuessSelectionsEntity duibaGuessSelections) {
		insert("insert", duibaGuessSelections);
	}

	@Override
	public void update4Admin(Long id, Long duibaGuessId, Integer position, String content) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("id", id);
		paramMap.put("duibaGuessId", duibaGuessId);
		paramMap.put("position", position);
		paramMap.put("content", content);
		update("update4Admin", paramMap);

	}

	@Override
	public List<DuibaGuessSelectionsEntity> findAllByGuessId(Long duibaGuessId) {
		return selectList("findAllByGuessId", duibaGuessId);
	}
	
	@Override
    public int delete(List<Long> ids) {
        Map<String, Object> params=new HashMap<String, Object>();
        params.put("ids", ids);
        return update("delete", params);
    }

	/**
	 * 这个方法延迟到子类实现,由子类决定注入哪个sqlSessionTemplate,以使用不同的库
	 *
	 * @return
	 */
	@Override
	protected DatabaseSchema chooseSchema() {
		return DatabaseSchema.GUESS;
	}
}
