package cn.com.duiba.activity.center.biz.dao.guess.impl;

import cn.com.duiba.activity.center.biz.dao.ActivityBaseDao;
import cn.com.duiba.activity.center.biz.dao.DatabaseSchema;
import cn.com.duiba.activity.center.biz.dao.guess.GuessOrdersStatusChangeDao;
import cn.com.duiba.activity.center.biz.entity.guess.GuessOrdersEntity;
import org.springframework.stereotype.Repository;

import java.util.Calendar;
import java.util.Date;
import java.util.Map;

import static cn.com.duiba.activity.center.biz.support.TableHelper.getTbSuffixParamsMap;
import static cn.com.duiba.activity.center.biz.support.TableHelper.subString;

/**
 * Created by yansen on 16/7/18.
 */
@Repository
public class GuessOrdersStatusChangeDaoImpl extends ActivityBaseDao implements GuessOrdersStatusChangeDao {

    @Override
    public int updateStatusToConsumeSuccess(Long consumerId, Long gameOrderId) {
        //加入异常捕获，防止在过度其间抛出异常，流程中断。
        Map<String, Object> paramMap = getTbSuffixParamsMap(consumerId);
        paramMap.put("id", gameOrderId);
        paramMap.put("status", GuessOrdersEntity.StatusConsumeSuccess);
        int ret = update("updateStatusToConsumeSuccess", paramMap);
        return ret;
    }

    @Override
    public int updateStatusToFail(Long consumerId, Long guessOrderId, String error4admin, String error4developer, String error4consumer) {

        //加入异常捕获，防止在过度其间抛出异常，流程中断。
        Map<String, Object> paramMap = getTbSuffixParamsMap(consumerId);
        paramMap.put("id", guessOrderId);
        paramMap.put("status", GuessOrdersEntity.StatusFail);
        paramMap.put("error4admin", subString(error4admin, 200));
        paramMap.put("error4developer", subString(error4developer, 200));
        paramMap.put("error4consumer", subString(error4consumer, 200));
        int ret = update("updateStatusToFail", paramMap);
        return ret;
    }

    @Override
    public int updateStatusToSuccess(Long consumerId, Long guessOrderId, Long guessOrderExtraId) {
        //加入异常捕获，防止在过度其间抛出异常，流程中断。
        Map<String, Object> paramMap = getTbSuffixParamsMap(consumerId);
        paramMap.put("id", guessOrderId);
        paramMap.put("status", GuessOrdersEntity.StatusSuccess);
        paramMap.put("guessOrderExtraId", guessOrderExtraId);
        int ret = update("updateStatusToSuccess", paramMap);
        return ret;
    }

    @Override
    public int updateExchangeStatusToWaitOpen(Long consumerId, Long guessOrderId) {
        //加入异常捕获，防止在过度其间抛出异常，流程中断。
        Map<String, Object> paramMap = getTbSuffixParamsMap(consumerId);
        paramMap.put("id", guessOrderId);
        paramMap.put("status", GuessOrdersEntity.StatusSuccess);
        paramMap.put("exchangeStatus", GuessOrdersEntity.ExchangeStatusWaitOpen);
        int ret = update("updateExchangeStatusToWaitOpen", paramMap);
        return ret;
    }

    @Override
    public int updateExchangeStatusToWait(Long consumerId, Long guessOrderId, Long itemId, Long appItemId, Long prizeId, String prizeType, String prizeName, String prizeFacePrice, Long couponId) {
        //加入异常捕获，防止在过度其间抛出异常，流程中断。
        Map<String, Object> paramMap = getTbSuffixParamsMap(consumerId);
        paramMap.put("id", guessOrderId);
        paramMap.put("status", GuessOrdersEntity.StatusSuccess);
        paramMap.put("exchangeStatus", GuessOrdersEntity.ExchangeStatusWait);
        paramMap.put("itemId", itemId);
        paramMap.put("appItemId", appItemId);
        paramMap.put("prizeId", prizeId);
        paramMap.put("prizeType", prizeType);
        paramMap.put("prizeName", prizeName);
        paramMap.put("prizeFacePrice", prizeFacePrice);
        paramMap.put("couponId", couponId);
        int ret = update("updateExchangeStatusToWait", paramMap);
        return ret;
    }


    @Override
    public int doTakePrize(Long consumerId, Long id) {
        //加入异常捕获，防止在过度其间抛出异常，流程中断。
        Map<String, Object> paramMap = getTbSuffixParamsMap(consumerId);
        paramMap.put("id", id);
        int ret = update("doTakePrize", paramMap);
        return ret;
    }

    @Override
    public int rollbackTakePrize(Long consumerId, Long id) {
        //加入异常捕获，防止在过度其间抛出异常，流程中断。
        Map<String, Object> paramMap = getTbSuffixParamsMap(consumerId);
        paramMap.put("id", id);
        int ret = update("rollbackTakePrize", paramMap);
        return ret;
    }

    @Override
    public int updateManualOpenPrizeExchangeStatusToWait(Long consumerId, Long guessOrderId, Long itemId, Long appItemId, Long prizeId, String prizeType, String prizeName, String prizeFacePrice, Long couponId) {
        //加入异常捕获，防止在过度其间抛出异常，流程中断。
        Map<String, Object> paramMap = getTbSuffixParamsMap(consumerId);
        paramMap.put("id", guessOrderId);
        paramMap.put("exchangeStatus", GuessOrdersEntity.ExchangeStatusWait);
        paramMap.put("itemId", itemId);
        paramMap.put("appItemId", appItemId);
        paramMap.put("prizeId", prizeId);
        paramMap.put("prizeType", prizeType);
        paramMap.put("prizeName", prizeName);
        paramMap.put("prizeFacePrice", prizeFacePrice);
        paramMap.put("couponId", couponId);
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        cal.add(Calendar.DATE, +7);
        Date prizeOverdueDate = cal.getTime();
        paramMap.put("prizeOverdueDate", prizeOverdueDate);
        int ret = update("updateManualOpenPrizeExchangeStatusToWait", paramMap);
        return ret;
    }

    @Override
    public int updateExchangeStatusToFail(Long consumerId, Long guessOrderId, String error4admin, String error4developer, String error4consumer) {
        //加入异常捕获，防止在过度其间抛出异常，流程中断。
        Map<String, Object> paramMap = getTbSuffixParamsMap(consumerId);
        paramMap.put("id", guessOrderId);
        paramMap.put("exchangeStatus", GuessOrdersEntity.ExchangeStatusFail);
        paramMap.put("error4admin", subString(error4admin, 200));
        paramMap.put("error4developer", subString(error4developer, 200));
        paramMap.put("error4consumer", subString(error4consumer, 200));
        int ret = update("updateExchangeStatusToFail", paramMap);
        return ret;
    }

    @Override
    public int updateExchangeStatusToWaitOpenAndExtraId(Long consumerId, Long guessOrderId, Long guessOrderExtraId) {
        //加入异常捕获，防止在过度其间抛出异常，流程中断。
        Map<String, Object> paramMap = getTbSuffixParamsMap(consumerId);
        paramMap.put("id", guessOrderId);
        paramMap.put("status", GuessOrdersEntity.StatusSuccess);
        paramMap.put("exchangeStatus", GuessOrdersEntity.ExchangeStatusWaitOpen);
        paramMap.put("guessOrderExtraId", guessOrderExtraId);
        int ret = update("updateExchangeStatusToWaitOpenAndExtraId", paramMap);
        return ret;
    }

    @Override
    public int updateIsGivePrize(Long consumerId, Long id, int isGivePrize) {
        //加入异常捕获，防止在过度其间抛出异常，流程中断。
        Map<String, Object> paramMap = getTbSuffixParamsMap(consumerId);
        paramMap.put("id", id);
        paramMap.put("isGivePrize", isGivePrize);
        int ret = update("updateIsGivePrize", paramMap);
        return ret;
    }

    public int updateExchangeStatusToOverdue(Long consumerId, long id, String error4admin, String error4developer, String error4consumer) {
        Map<String, Object> paramMap = getTbSuffixParamsMap(consumerId);
        paramMap.put("id", id);
        paramMap.put("exchangeStatus", GuessOrdersEntity.ExchangeStatusOverdue);
        paramMap.put("error4admin", subString(error4admin, 200));
        paramMap.put("error4developer", subString(error4developer, 200));
        paramMap.put("error4consumer", subString(error4consumer, 200));
        int ret = update("updateExchangeStatusToOverdue", paramMap);
        return ret;
    }

    @Override
    public int updateExchangeStatusToWaitOpenAndExtraIdForLuck(Long consumerId, Long guessOrderId, Long guessOrderExtraId) {
        //加入异常捕获，防止在过度其间抛出异常，流程中断。
        Map<String, Object> paramMap = getTbSuffixParamsMap(consumerId);
        paramMap.put("id", guessOrderId);
        paramMap.put("status", GuessOrdersEntity.StatusSuccess);
        paramMap.put("exchangeStatus", GuessOrdersEntity.ExchangeStatusWaitOpen);
        paramMap.put("guessOrderExtraId", guessOrderExtraId);
        int ret = update("updateExchangeStatusToWaitOpenAndExtraId", paramMap);
        return ret;
    }

    /**
     * 这个方法延迟到子类实现,由子类决定注入哪个sqlSessionTemplate,以使用不同的库
     *
     * @return
     */
    @Override
    protected DatabaseSchema chooseSchema() {
        return DatabaseSchema.GUESS_CON;
    }
}
