package cn.com.duiba.activity.center.biz.dao.hdtool.impl;

import cn.com.duiba.activity.center.biz.dao.ActivityBaseDao;
import cn.com.duiba.activity.center.biz.dao.DatabaseSchema;
import cn.com.duiba.activity.center.biz.dao.hdtool.HdtoolOrdersDao;
import cn.com.duiba.activity.center.biz.entity.hdtool.HdtoolOrdersEntity;
import org.springframework.stereotype.Repository;

import java.util.*;

/**
 * 活动工具订单业务DAO
 */
@Repository
public class HdtoolOrdersDaoImpl extends ActivityBaseDao implements HdtoolOrdersDao {

	/**
	 * 根据ID查询订单
	 */
	public HdtoolOrdersEntity find(Long id) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("id", id);
		return selectOne("find", paramMap);
	}

	/**
	 * 根据活动主订单ID集合查询订单信息
	 */
	public List<HdtoolOrdersEntity> findInOrderIds(List<Long> ids) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("ids", ids);
		return selectList("findInOrderIds", paramMap);
	}

	/**
	 * 根据领取状态exchangeStatus查询小于endTime时间的订单
	 */
	public List<HdtoolOrdersEntity> findExpireOrder() {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		Calendar cal = Calendar.getInstance();
		cal.setTime(new Date());
		cal.add(Calendar.DATE, -1);
		Date endTime = cal.getTime();
		Calendar cal1 = Calendar.getInstance();
		cal1.setTime(endTime);
		cal1.add(Calendar.DATE, -1);
		Date startTime = cal1.getTime();
		paramMap.put("startTime", startTime);
		paramMap.put("endTime", endTime);
		paramMap.put("exchangeStatus", HdtoolOrdersEntity.ExchangeStatusWait);
		return selectList("findExpireOrder", paramMap);
	}

	@Override
	protected DatabaseSchema chooseSchema() {
		return DatabaseSchema.MNG_HDTOOL;
	}
}
