/**
 * Project Name:activity-center-biz
 * File Name:ActivityConsumerCreditsCallback.java
 * Package Name:cn.com.duiba.activity.center.biz.kafka.callback
 * Date:2016年7月31日下午6:30:37
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.activity.center.biz.kafka.callback;

import java.util.Arrays;
import java.util.Collections;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;

import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.TopicPartition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.activity.center.biz.kafka.KafkaClient;
import cn.com.duiba.activity.center.biz.kafka.TopicConstant;
import cn.com.duiba.activity.center.biz.plugin.buckle.ConsumerCreditsService;
import cn.com.duiba.order.center.api.dto.CreditsCallbackMessage;

import com.alibaba.fastjson.JSONObject;

/**
 * ClassName:ActivityConsumerCreditsCallback <br/>
 * Function: TODO ADD FUNCTION. <br/>
 * Reason:	 TODO ADD REASON. <br/>
 * Date:     2016年7月31日 下午6:30:37 <br/>
 * @author   zp
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
@Service
public class ActivityConsumerCreditsCallback implements InitializingBean{
    
    private static Logger log = LoggerFactory.getLogger(ActivityConsumerCreditsCallback.class);

    @Autowired
    private KafkaClient kafkaClient;
    @Autowired
    private TopicConstant topicConstant;
    @Autowired
    private ConsumerCreditsService consumerCreditsService;
    /**
     * 消费线程数
     */
    private static int pool = 3;
    private ExecutorService executorService;

    public void start() {
        if (executorService != null) {
            return;
        }
        executorService = Executors.newFixedThreadPool(pool,new ThreadFactory() {
            private int i = 0;

            @Override
            public Thread newThread(Runnable runnable) {
                return new Thread(runnable, "Thread-Activity-ConsumerCredits-" + (i++));
            }
        });
        for (int i = 0; i < pool; i++) {
            executorService.submit(new Runnable() {
                @Override
                public void run() {
                    try {
                        Properties props = new Properties();
                        props.put("bootstrap.servers", kafkaClient.getBootstrapServers());
                        props.put("group.id", "credits_consumer");
                        props.put("enable.auto.commit", "false");
                        props.put("session.timeout.ms", "30000");
                        props.put("auto.offset.reset", "earliest");
                        props.put("key.deserializer", "org.apache.kafka.common.serialization.StringDeserializer");
                        props.put("value.deserializer", "org.apache.kafka.common.serialization.StringDeserializer");
                        KafkaConsumer<String, String> consumer = new KafkaConsumer<String, String>(props);
                        consumer.subscribe(Arrays.asList(topicConstant.getTopicConsumerCreditsResponse()));
                        while (true) {
                            if (Thread.currentThread().isInterrupted()) {
                                break;
                            }
                            ConsumerRecords<String, String> records = consumer.poll(100);
                            for (TopicPartition pt : records.partitions()) {
                                for (ConsumerRecord<String, String> record : records.records(pt)) {
                                    try {
                                        CreditsCallbackMessage response = JSONObject.parseObject(record.value(), CreditsCallbackMessage.class);
                                        consumerCreditsService.creditsCallback(response);
                                    } catch (Exception e) {
                                        log.error("activity consumer credits error:", e);
                                    } finally {
                                        long lastOffset = record.offset();
                                        consumer.commitSync(Collections.singletonMap(pt, new OffsetAndMetadata(lastOffset + 1)));
                                    }
                                }
                            }
                        }
                        consumer.close();
                    } catch (Exception e) {
                        log.error("error:", e);
                    }
                }
            });
        }
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        start();
    }

}

