package cn.com.duiba.activity.center.biz.plugin.buckle.impl;

import java.util.List;
import java.util.Map;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;

import cn.com.duiba.activity.center.api.dto.plugin.ActivityPluginDto;
import cn.com.duiba.activity.center.api.dto.prize.ActivityPrizeOptionDto;
import cn.com.duiba.activity.center.biz.exception.DeveloperConsumeFailedException;
import cn.com.duiba.activity.center.biz.plugin.buckle.ConsumerPluginService;
import cn.com.duiba.activity.center.biz.plugin.event.DuibaEventsDispatcher;
import cn.com.duiba.activity.center.biz.plugin.event.credits.ConsumeCreditsFailEvent;
import cn.com.duiba.activity.center.biz.plugin.event.credits.ConsumerCreditsSuccessEvent;
import cn.com.duiba.activity.center.biz.plugin.event.order.ActivityOrdersEvent;
import cn.com.duiba.activity.center.biz.plugin.event.order.ActivityOrdersEvent.ActivityOrdersEventType;
import cn.com.duiba.activity.center.biz.service.plugin.PluginFlowInnerService;
import cn.com.duiba.activity.center.biz.service.prize.ActivityPrizeOptionService;
import cn.com.duiba.activity.center.common.util.LogUtil;
import cn.com.duiba.order.center.api.dto.ActivityOrderDto;
import cn.com.duiba.order.center.api.dto.CreditsCallbackMessage;
import cn.com.duiba.order.center.api.remoteservice.RemoteActivityOrderService;
import cn.com.duiba.service.remoteservice.RemoteConsumerService;
import cn.com.duiba.wolf.dubbo.DubboResult;

/** 
 * ClassName:ConsumerPluginServiceImpl.java <br/>
 * @author  gey 
 * @date 创建时间：2016年10月19日 下午4:53:14 
 * @version 1.0 
 * @parameter  
 * @since   JDK 1.6
 */
@Service
public class ConsumerPluginServiceImpl implements ConsumerPluginService {
	
	private static Logger log = LoggerFactory.getLogger(ConsumerPluginServiceImpl.class);
	@Autowired
	private RemoteActivityOrderService remoteActivityOrderService;
	@Autowired
	private RemoteConsumerService remoteConsumerService;
	@Autowired
	private ActivityPrizeOptionService activityPrizeOptionService;
	@Autowired
	private PluginFlowInnerService pluginFlowInnerService;
	@Override
	public void asyncConsumerPlug(Long consumerId, String orderNum,
			String transfer, String ip,String ua,
			String os, ActivityPluginDto pluDto) {

		//查询订单
		DubboResult<ActivityOrderDto> order = remoteActivityOrderService.findByOrderNum(orderNum);
		if(!order.isSuccess() || order.getResult() == null){
			CreditsCallbackMessage message = new CreditsCallbackMessage();
			message.setAppId(order.getResult().getAppId().toString());
			message.setRelationId(order.getResult().getOrderNum());
			message.setRelationType(order.getResult().getActivityType());
			Map<String,String> params = Maps.newHashMap();
			params.put("ip", ip);
			message.setParams(params);
			onCreditsFail(message,new Exception("订单号不存在"));
			return;
		}
		
		CreditsCallbackMessage message = new CreditsCallbackMessage();
		message.setAppId(order.getResult().getAppId().toString());
		message.setRelationId(order.getResult().getOrderNum());
		message.setRelationType(order.getResult().getActivityType());
		Map<String,String> params = Maps.newHashMap();
		params.put("ip", ip);
		message.setParams(params);
		onCreditsSuccess(message,ua,os,pluDto);
	}
	/**
	 * 生成订单失败
	 * onCreditsFail:(这里用一句话描述这个方法的作用). <br/>
	 * @author gey
	 * @param message
	 * @param exception
	 * @since JDK 1.6
	 */
	private void onCreditsFail(CreditsCallbackMessage message,Exception exception) {
		ActivityOrderDto order = remoteActivityOrderService.findByOrderNum(message.getRelationId()).getResult();
		try {
			ActivityOrderDto o4u = new ActivityOrderDto();
			if ((exception instanceof DeveloperConsumeFailedException) && ((DeveloperConsumeFailedException) exception).getNormalFail()) {
				o4u.setError4admin("扣积分失败，开发者返回扣积分失败。" + exception.getMessage());
				o4u.setError4developer("扣积分失败，开发者返回扣积分失败。");
				o4u.setError4consumer("抽奖失败，请稍后再试。");
			} else {
				o4u.setError4admin("扣积分失败，开发者服务器异常。" + exception.getMessage());
				o4u.setError4developer("扣积分失败，" + exception.getMessage());
				o4u.setError4consumer("抽奖失败，请稍后再试。");
			}
			remoteActivityOrderService.consumeCreditsFail(order.getOrderNum(),null, null, 
														  null, null, null, null, null, null, null,
														  o4u.getError4admin(),o4u.getError4developer(),o4u.getError4consumer());
			// 返还本地积分
			if (order.getConsumeCredits() > 0) {
				remoteConsumerService.increaseCredits(order.getConsumerId(), order.getConsumeCredits());
			}
		} catch (Exception e) {
			log.error("活动抽奖异常:", e);
		} finally {
			complete(order.getOrderNum());
			// 发出扣积分失败事件
			DuibaEventsDispatcher.get().dispatchConsumeCreditsFailEvent(new ConsumeCreditsFailEvent(order, exception));
		}
	}

	private void complete(String orderNum) {
		// 查询最新订单信息
		ActivityOrderDto order = remoteActivityOrderService.findByOrderNum(orderNum).getResult();
		// 发出活动订单事件
		if (order.getConsumeCreditsStatus() == ActivityOrderDto.ConsumeCreditsSuccess) {
			DuibaEventsDispatcher.get().dispatchEvent(new ActivityOrdersEvent(ActivityOrdersEventType.OnOrderSuccess, order));
		} else if (order.getConsumeCreditsStatus() == ActivityOrderDto.ConsumeCreditsFail) {
			DuibaEventsDispatcher.get().dispatchEvent(new ActivityOrdersEvent(ActivityOrdersEventType.OnOrderFail, order));
		}
	}
	
	private void onCreditsSuccess(CreditsCallbackMessage message, String ua,String os,ActivityPluginDto pluDto) {
		String ip = message.getParams().get("ip");
		ActivityOrderDto order = remoteActivityOrderService.findByOrderNum(message.getRelationId()).getResult();
		List<ActivityPrizeOptionDto> options = Lists.newArrayList();
		//查询奖项
		if(order.getActivityType().equals(ActivityOrderDto.TypePlugin)){
			options = activityPrizeOptionService.queryActivityOptionsByConfigId(order.getDuibaActivityId(),ActivityPrizeOptionDto.Activity_Type_Plugin);
		} 
		//根据概率选取一个奖项
		ActivityPrizeOptionDto winOption = pluginFlowInnerService.randomPrize(order.getDuibaActivityId(),order.getActivityType(), options);

		try{
			//奖项配置与属性的验证
			log.error("pluginFlowInnerService.winOptionCheck    开始！");
			winOption = pluginFlowInnerService.winOptionCheck(order,winOption,options);
			pluginFlowInnerService.doWinPrize(order, winOption, options,ip,ua,os,pluDto);
			
		}catch(Exception e){
			log.error("抽奖异常:福袋，若奖项没有配置福袋则中 谢谢参与", e);
			LogUtil.logPluginKan("ConsumerPluginServiceImpl onCreditsSuccess 根据概率选取的一个奖项 winOption===>"+JSONObject.toJSONString(winOption));
			try{
				ActivityPrizeOptionDto option = pluginFlowInnerService.awardOptionLuck(order.getDuibaActivityId(), order.getActivityType(), options);
				winOption = pluginFlowInnerService.winOptionCheck(order,option,options);
				pluginFlowInnerService.doWinPrize(order, winOption, options,ip,ua,os,pluDto);
			}catch(Exception e1){
				log.error("抽奖异常,降级为优惠券出错:",e1);
				try{
					ActivityPrizeOptionDto option =pluginFlowInnerService.awardThanks(order.getDuibaActivityId(), order.getActivityType());
					// 更新订单中奖信息
					remoteActivityOrderService.consumeCreditsSuccessDowngrade(order.getOrderNum(),option.getId(),option.getPrizeName(),
							option.getPrizeType(),option.getFacePrice(),option.getAppItemId(),option.getItemId(),option.getgId(),option.getgType(),null);
				}catch(Exception e3){
					log.error("抽奖异常: 降级为谢谢参与，仍然出错 ", e3);
				}
			}
		}finally{
			this.complete(order.getOrderNum());
			// 发出扣积分成功事件
			ActivityOrderDto orderNew = remoteActivityOrderService.findByOrderNum(message.getRelationId()).getResult();
			DuibaEventsDispatcher.get().dispatchConsumeCreditsSuccessEvent(new ConsumerCreditsSuccessEvent(orderNew));
		}
	}
}
