/**
 * Project Name:activity-center-biz
 * File Name:ActivityOrderToDeveloperTool.java
 * Package Name:cn.com.duiba.activity.center.biz.plugin.buckle.impl
 * Date:2016年7月28日下午4:42:31
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.activity.center.biz.plugin.buckle.impl;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import cn.com.duiba.activity.center.biz.exception.DeveloperConsumeFailedException;
import cn.com.duiba.activity.center.biz.plugin.buckle.ConsumerCutCreditsService;
import cn.com.duiba.activity.center.biz.plugin.buckle.LittleGameConsumerCreditsCallback;
import cn.com.duiba.activity.center.biz.pool.ThreadPoolLotteryService;
import cn.com.duiba.activity.center.common.util.LogUtil;
import cn.com.duiba.order.center.api.dto.ActivityOrderDto;
import cn.com.duiba.order.center.api.dto.CreditsCallbackMessage;
import cn.com.duiba.order.center.api.remoteservice.RemoteActivityOrderService;
import cn.com.duiba.service.remoteservice.RemoteConsumerService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.com.duiba.idmaker.service.api.enums.IdempotentTypeEnums;
import cn.com.duiba.idmaker.service.api.remoteservice.RemoteIdempotentService;

/**
 * describe : 小游戏扣积分
 * @author  : cdm
 * @date    : 2016年11月2日 下午8:12:50
 */
@Component
public class LittleGameConsumerCreditsCallbackImpl implements LittleGameConsumerCreditsCallback{
    
    private static Logger log = LoggerFactory.getLogger(LittleGameConsumerCreditsCallbackImpl.class);
    @Autowired
    private ConsumerCutCreditsService consumerCutCreditsService;
    @Autowired
    private RemoteConsumerService remoteConsumerService;
    @Autowired
    private RemoteActivityOrderService remoteActivityOrderService;
    @Autowired
    private RemoteIdempotentService remoteIdempotentService;

    @Override
    public void cancelled(final CreditsCallbackMessage message){
        final DeveloperConsumeFailedException exception = new DeveloperConsumeFailedException("","请求被取消");
        exception.setUrl(message.getHttpUrl());
        exception.setDevRespone(message.getMessage());
        exception.setFailType(DeveloperConsumeFailedException.FailTypeDefault);
        exception.setInterfaceType(DeveloperConsumeFailedException.ConsumerCreditsType);
        exception.setNormalFail(false);
        ThreadPoolLotteryService.get().submit(new Runnable() {
            @Override
            public void run() {
            	consumerCutCreditsService.onCreditsFail(message, exception);
            }
        });
        
    }
    
    @Override
    public void completed(final CreditsCallbackMessage message){
        LogUtil.logTodayKan("进入扣积分回调start.....");
        Exception exception = null;
        try{
            successBlock(message);
        }catch(Exception e){
            exception = e;
            if(!(e instanceof DeveloperConsumeFailedException)){
                DeveloperConsumeFailedException exc = new DeveloperConsumeFailedException("","向开发者请求扣积分，网络请求出错");
                exc.setUrl(message.getHttpUrl());
                exc.setDevRespone(message.getMessage());
                exc.setDevRespone(e.getMessage());
                exc.setFailType(DeveloperConsumeFailedException.FailTypeDefault);
                exc.setInterfaceType(DeveloperConsumeFailedException.ConsumerCreditsType);
                exc.setNormalFail(false);
                exception=exc;
            }
        }
        final Exception finallyE=exception; 
        ThreadPoolLotteryService.get().submit(new Runnable() {
            public void run() {
                if(finallyE == null){
                    LogUtil.logTodayKan("ThreadPoolLotteryService run 进入扣积分success start.....");
                    consumerCutCreditsService.onCreditsSuccess(message);
                    LogUtil.logTodayKan("ThreadPoolLotteryService run 进入扣积分success end.....");
                }else{
                    LogUtil.logTodayKan("ThreadPoolLotteryService run 进入扣积分failed start.....");
                    consumerCutCreditsService.onCreditsFail(message, finallyE);
                    LogUtil.logTodayKan("ThreadPoolLotteryService run 进入扣积分failed end.....");
                }
            }
        });
        LogUtil.logTodayKan("进入扣积分回调end.....");
    }
    
    @Override
    public void failed(final CreditsCallbackMessage message){
        log.info("向开发者请求扣积分，网络请求出错:", new Exception(message.getMessage()));
        DeveloperConsumeFailedException exc = new DeveloperConsumeFailedException("","向开发者请求扣积分，网络请求出错");
        exc.setUrl(message.getHttpUrl());
        exc.setDevRespone(message.getMessage());
        exc.setFailType(DeveloperConsumeFailedException.FailTypeDefault);
        exc.setInterfaceType(DeveloperConsumeFailedException.ConsumerCreditsType);
        exc.setNormalFail(false);
        final Exception finallyE=exc; 
        ThreadPoolLotteryService.get().submit(new Runnable() {
            @Override
            public void run() {
            	consumerCutCreditsService.onCreditsFail(message, finallyE);
            }
        });
    }
    
    private void successBlock(CreditsCallbackMessage message) throws Exception{
        JSONObject o = null;
        try {
            o = JSON.parseObject(message.getMessage());
        } catch (Exception e) {
            log.error("json解析失败",e);
            DeveloperConsumeFailedException exc = new DeveloperConsumeFailedException("","开发者服务器响应内容JSON解析失败");
            exc.setUrl(message.getHttpUrl());
            exc.setDevRespone(message.getMessage());
            exc.setFailType(DeveloperConsumeFailedException.FailTypeJson);
            exc.setInterfaceType(DeveloperConsumeFailedException.ConsumerCreditsType);
            exc.setNormalFail(false);
            throw exc;
        }
        if (o == null) {
            throw new Exception("服务器异常");
        }
        JSONObject json = getOneDegreeJson(o);
        if ("ok".equalsIgnoreCase(json.getString("status"))) {
            final Long credits = json.getLong("credits");
            String orderNum = message.getRelationId();
            ActivityOrderDto order = remoteActivityOrderService.findByOrderNum(orderNum).getResult();
            if (credits != null && credits >= 0) {
                remoteConsumerService.updateCredits(order.getConsumerId(), credits);
            }
            final String bizId = json.getString("bizId");
            if(StringUtils.isBlank(bizId)){
                DeveloperConsumeFailedException exc = new DeveloperConsumeFailedException("","开发者服务器响应开发订单号为空");
                exc.setUrl(message.getHttpUrl());
                exc.setDevRespone(message.getMessage());
                exc.setFailType(DeveloperConsumeFailedException.FailTypeJson);
                exc.setInterfaceType(DeveloperConsumeFailedException.ConsumerCreditsType);
                exc.setNormalFail(false);
                throw exc;
            }
            try {
                DubboResult<Boolean> bo = remoteIdempotentService.createIdempotent(IdempotentTypeEnums.ACTIVITY, bizId + "-" + order.getAppId(), 60 * 60 * 24 * 30);
                log.error("->>idMark验证信息:bizId=" + bizId + ";message=" + bo.getMsg() + ";success:" + bo.isSuccess());
                if(!bo.isSuccess()){
                    throw new Exception("开发者订单号重复");
                }
            } catch (Exception e) {
                log.error("开发者订单号重复，APP=" + message.getAppId(), e);
                DeveloperConsumeFailedException exc = new DeveloperConsumeFailedException("","创建订单失败,开发者订单号不能重复");
                exc.setUrl(message.getHttpUrl());
                exc.setDevRespone(message.getMessage());
                exc.setFailType(DeveloperConsumeFailedException.FailTypebizId);
                exc.setInterfaceType(DeveloperConsumeFailedException.ConsumerCreditsType);
                exc.setNormalFail(false);
                throw exc;
            }
            remoteActivityOrderService.updateDeveloperBizId(orderNum, bizId);
        } else {
            DeveloperConsumeFailedException dcf = new DeveloperConsumeFailedException("", json.getString("errorMessage"));
            dcf.setNormalFail(true);
            throw dcf;
        }
    }
    
    private JSONObject getOneDegreeJson(JSONObject o){
        JSONObject json = new JSONObject();
        for (String key : o.keySet()) {
            if(o.get(key) instanceof JSONObject){
                JSONObject json2 = (JSONObject) o.get(key);
                for (String key2 : json2.keySet()) {
                    json.put(key2, json2.get(key2));
                }
            }else{
                json.put(key, o.get(key));
            }
        }
        return json;
    }
}

