/**
 * Project Name:activity-center-biz
 * File Name:ActivityObjectStockPluginImpl.java
 * Package Name:cn.com.duiba.activity.center.biz.plugin.stock
 * Date:2016年7月29日下午3:37:57
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.activity.center.biz.plugin.stock;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import cn.com.duiba.activity.center.api.dto.prize.ActivityPrizeOptionDto;
import cn.com.duiba.activity.center.biz.plugin.event.DuibaEventsRegister;
import cn.com.duiba.activity.center.biz.plugin.event.order.ActivityOrderSyncEvent;
import cn.com.duiba.order.center.api.dto.ActivityOrderDto;
import cn.com.duiba.service.domain.dataobject.ItemDO;
import cn.com.duiba.service.domain.vo.ItemKey;
import cn.com.duiba.service.item.domain.dataobject.ItemStockConsumeDO;
import cn.com.duiba.service.item.remoteservice.RemoteItemKeyService;
import cn.com.duiba.service.item.remoteservice.RemoteItemStockConsumeService;

/**
 * ClassName:ActivityObjectStockPluginImpl <br/>
 * Function: TODO ADD FUNCTION. <br/>
 * Reason:	 TODO ADD REASON. <br/>
 * Date:     2016年7月29日 下午3:37:57 <br/>
 * @author   zp
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
@Component
public class ActivityObjectStockPluginImpl implements InitializingBean{

    private static Logger log = LoggerFactory.getLogger(ActivityObjectStockPluginImpl.class);
    @Autowired
    private RemoteItemStockConsumeService remoteItemStockConsumeService;
    @Autowired
    private RemoteItemKeyService remoteItemKeyService;
    
    private ActivityOrderSyncEvent orderPlugin = new ActivityOrderSyncEvent(){

        private static final String ACTIVITY_ObJ_STOCK = "__activity_obj_stock_consume";
        
        @Override
        public void afterOrderCreate(ActivityOrderDto order) {
            
        }

        @Override
        public void beforeStockComplete(ActivityOrderDto order, ActivityPrizeOptionDto option,
                                        ActivityOrderPluginContext context) throws Exception {
            if (option.getPrizeType().equals(ItemDO.TypeObject)) {
                    try{
                        ItemKey key = remoteItemKeyService.getItemKey(option.getItemId(), option.getAppItemId(), order.getAppId());
                        remoteItemStockConsumeService.consumeStock(key, order.getOrderNum(), ItemStockConsumeDO.BIZ_SOURCE_ACTIVITY);
                        context.setAttribute(ACTIVITY_ObJ_STOCK, true);
                    }catch(Exception e){
                        log.error("className: "+this.getClass().getName()+" method: consumeStock,活动工具减库存失败",e);
                        throw e;
                    }
                }
        }

        @Override
        public void beforeStockCompleteException(ActivityOrderDto order, ActivityPrizeOptionDto option,
                                                 Exception exception, ActivityOrderPluginContext context) {
            if (option.getPrizeType().equals(ItemDO.TypeObject)) {
                try{
                    Boolean hasadd=(Boolean) context.getAttribute(ACTIVITY_ObJ_STOCK);
                    
                    if(hasadd!=null && hasadd){
                        remoteItemStockConsumeService.paybackStock(order.getOrderNum(), ItemStockConsumeDO.BIZ_SOURCE_ACTIVITY);
                    }
                    
                    context.remove(ACTIVITY_ObJ_STOCK);
                }catch(Exception e){
                    log.error("className: "+this.getClass().getName()+" method: consumeStock,活动工具返库存失败",e);
                }
            }
        }
        
    };
    
    @Override
    public void afterPropertiesSet() throws Exception {
        DuibaEventsRegister.get().addActivityOrdersPlugin(orderPlugin);
    }

}

