package cn.com.duiba.activity.center.biz.remoteservice.impl.elasticgifts;

import cn.com.duiba.activity.center.api.dto.elasticgifts.ElasticGiftsTermDto;
import cn.com.duiba.activity.center.api.dto.elasticgifts.ElasticGiftsTermSimpleDto;
import cn.com.duiba.activity.center.api.enums.ElasticGiftsTermTypeEnum;
import cn.com.duiba.activity.center.api.remoteservice.elasticgifts.RemoteElasticGiftsTermBackendService;
import cn.com.duiba.activity.center.biz.service.elasticgifts.ElasticGiftsTermService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Service("remoteElasticGiftsTermBackendService")
public class RemoteElasticGiftsTermBackendServiceImpl implements RemoteElasticGiftsTermBackendService {

    private static Logger LOGGER = LoggerFactory.getLogger(RemoteElasticGiftsTermBackendServiceImpl.class);

    @Autowired
    private ElasticGiftsTermService elasticGiftsTermService;

    @Override
    public DubboResult<List<ElasticGiftsTermSimpleDto>> getTermsByElasticGiftsId(Long elasticGiftsId) {
        try {
            List<ElasticGiftsTermSimpleDto> result = elasticGiftsTermService.getTermsByElasticGiftsId(elasticGiftsId);
            return DubboResult.successResult(result);
        } catch (Exception e) {
            LOGGER.error("getTermsByElasticGiftsId error", e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Boolean> sortTerms(List<Long> ids) {
        try {
            Boolean result = elasticGiftsTermService.sortTerms(ids);
            return DubboResult.successResult(result);
        } catch (Exception e) {
            LOGGER.error("sortTerms error", e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Boolean> delete(Long id) {
        try {
            Boolean result = elasticGiftsTermService.delete(id);
            return DubboResult.successResult(result);
        } catch (Exception e) {
            LOGGER.error("delete error", e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Boolean> save(Long id, ElasticGiftsTermTypeEnum typeEnum, Long termId, Long elasticGiftsId, String title, String subtitle, String payIntro, String btnText) {
        try {
            Boolean result = elasticGiftsTermService.save(id, typeEnum, termId, elasticGiftsId, title, subtitle, payIntro, btnText);
            return DubboResult.successResult(result);
        } catch (Exception e) {
            LOGGER.error("save error", e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<ElasticGiftsTermDto> getTermById(Long id) {
        try {
            ElasticGiftsTermDto result = elasticGiftsTermService.getTermById(id);
            return DubboResult.successResult(result);
        } catch (Exception e) {
            LOGGER.error("getTermById error", e);
            return DubboResult.failResult(e.getMessage());
        }
    }
}
