/**
 * Project Name:activity-center-biz File Name:RemoteShieldBackendServiceImpl.java Package
 * Name:cn.com.duiba.activity.center.biz.remoteservice.impl.gamecenter Date:2016年10月24日下午6:18:12 Copyright (c) 2016,
 * duiba.com.cn All Rights Reserved.
 */

package cn.com.duiba.activity.center.biz.remoteservice.impl.gamecenter;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.activity.center.api.dto.gamecenter.ShieldItemDto;
import cn.com.duiba.activity.center.api.remoteservice.gamecenter.RemoteShieldBackendService;
import cn.com.duiba.activity.center.biz.service.gamecenter.ActivityShieldService;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * ClassName:RemoteShieldBackendServiceImpl <br/>
 * Function: TODO ADD FUNCTION. <br/>
 * Reason: TODO ADD REASON. <br/>
 * Date: 2016年10月24日 下午6:18:12 <br/>
 * 
 * @author Zhuzhiyong
 * @version
 * @since JDK 1.6
 * @see
 */
@Service("remoteShieldBackendService")
public class RemoteShieldBackendServiceImpl implements RemoteShieldBackendService {

    @Autowired
    private ActivityShieldService activityShieldService;

    @Override
    public DubboResult<Boolean> isExist(Long appId, Integer activityType, Long activityId) {
        ShieldItemDto shieldItemDto = activityShieldService.findShield(appId, activityType, activityId);
        return DubboResult.successResult(shieldItemDto != null);
    }

    @Override
    public DubboResult<Long> addShield(ShieldItemDto shieldItemDto) {
        return DubboResult.successResult(activityShieldService.addShield(shieldItemDto));
    }

    @Override
    public DubboResult<Boolean> removeShield(Long shieldId) {
        return DubboResult.successResult(activityShieldService.removeShield(shieldId));
    }

}
