package cn.com.duiba.activity.center.biz.remoteservice.impl.guess;

import cn.com.duiba.activity.center.api.dto.guess.GuessOrdersDto;
import cn.com.duiba.activity.center.api.remoteservice.guess.RemoteGuessOrdersService;
import cn.com.duiba.activity.center.biz.service.guess.GuessOrdersService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * Created by yansen on 16/7/18.
 */
@Service
public class RemoteGuessOrdersServiceImpl implements RemoteGuessOrdersService {

    @Autowired
    private GuessOrdersService guessOrdersService;


    @Override
    public List<GuessOrdersDto> findWinByGuessIdAndPrizeId(Long duibaGuessId, Long prizeId) {
        return guessOrdersService.findWinByGuessIdAndPrizeId(duibaGuessId,prizeId);
    }

    /**
     * 精确匹配获取中奖名单
     *
     * @param duibaGuessId
     * @param winIds
     * @param guessData    @return
     */
    @Override
    public List<GuessOrdersDto> findWinOrderByExactMatch(Long duibaGuessId, List<String> winIds, String guessData) {
        return guessOrdersService.findWinOrderByExactMatch(duibaGuessId,winIds,guessData);
    }

    /**
     * 模糊匹配获取中奖名单
     *
     * @param duibaGuessId
     * @param num
     * @param luckNum
     * @param guessData    @return
     */
    @Override
    public List<GuessOrdersDto> findWinOrderByVagueMatch(Long duibaGuessId, int num, String luckNum, String guessData) {
        return guessOrdersService.findWinOrderByVagueMatch(duibaGuessId,num,luckNum,guessData);
    }

    @Override
    public List<GuessOrdersDto> findExpireOrder() {
        return guessOrdersService.findExpireOrder();
    }

    /**
     * 精确匹配获取中奖名单
     *
     * @param duibaGuessId
     * @param winIds
     * @param guessData
     * @param offset
     * @param max
     * @param consumerId   @return
     */
    @Override
    public List<GuessOrdersDto> findWinOrderByExactMatch(Long duibaGuessId, List<String> winIds, String guessData, Integer offset, Integer max, Long consumerId) {
        return guessOrdersService.findWinOrderByExactMatch(duibaGuessId,winIds,guessData,offset,max,consumerId);
    }

    /**
     * 模糊匹配获取中奖名单
     *
     * @param duibaGuessId
     * @param num
     * @param luckNum
     * @param guessData
     * @param offset
     * @param max
     * @param consumerId   @return
     */
    @Override
    public List<GuessOrdersDto> findWinOrderByVagueMatch(Long duibaGuessId, int num, String luckNum, String guessData, Integer offset, Integer max, Long consumerId) {
        return guessOrdersService.findWinOrderByVagueMatch(duibaGuessId, num, luckNum, guessData, offset, max, consumerId);
    }


}
