package cn.com.duiba.activity.center.biz.remoteservice.impl.rob.category;

import cn.com.duiba.activity.center.api.dto.rob.TodayRobConfigDto;
import cn.com.duiba.activity.center.api.dto.rob.category.RobActivityDto;
import cn.com.duiba.activity.center.api.dto.rob.category.RobCategoryDetailDto;
import cn.com.duiba.activity.center.api.dto.rob.category.RobCategoryDto;
import cn.com.duiba.activity.center.api.remoteservice.rob.category.RemoteRobCategoryService;
import cn.com.duiba.activity.center.biz.entity.robcategory.RobCategoryEntity;
import cn.com.duiba.activity.center.biz.service.rob.RobCategoryService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

/**
 * 描述:今日必抢分类相关逻辑操作实现类
 *
 * @author :sunchangji
 * @create :2016-10-17 17:40
 */
@Service
public class RemoteRobCategoryServiceImpl implements RemoteRobCategoryService {
    @Autowired
    private RobCategoryService robCategoryService;

    @Override
    public DubboResult<List<RobCategoryDto>> getAllCategory() {
        List<RobCategoryEntity> robCategoryEntityList = robCategoryService.getAllCategory();
        return DubboResult.successResult(robCategoryEntityListToDtoList(robCategoryEntityList));
    }

    public DubboResult<List<RobCategoryDto>> getByAppId(Long appId) {
        List<RobCategoryEntity> robCategoryEntityList = robCategoryService.getByAppId(appId);
        return DubboResult.successResult(robCategoryEntityListToDtoList(robCategoryEntityList));
    }

    @Override
    public DubboResult<List<TodayRobConfigDto>> getByCategoryId(Long categoryId, int offset, int pageSize) {
        return DubboResult.successResult(robCategoryService.getByCategoryId(categoryId, offset, pageSize));
    }

    @Override
    public DubboResult<List<RobActivityDto>> getForManageByCategoryId(Long categoryId) {
        return DubboResult.successResult(robCategoryService.getForManageByCategoryId(categoryId));
    }

    @Override
    public DubboResult<List<RobCategoryDto>> getCategoryByCategoryIds(final List<Long> categoryIdList) {
        List<RobCategoryEntity> robCategoryEntityList = robCategoryService.getRobCategorysByIds(categoryIdList);
        if (!CollectionUtils.isEmpty(robCategoryEntityList)) {
            //结果按categoryIds集合顺序排序
            Collections.sort(robCategoryEntityList, new Comparator<RobCategoryEntity>() {
                @Override
                public int compare(RobCategoryEntity o1, RobCategoryEntity o2) {
                    if (categoryIdList.indexOf(o1.getId()) > categoryIdList.indexOf(o2.getId())) {
                        return 1;
                    } else if (categoryIdList.indexOf(o1.getId()) < categoryIdList.indexOf(o2.getId())) {
                        return -1;
                    } else {
                        return 0;
                    }
                }
            });
        }
        return DubboResult.successResult(robCategoryEntityListToDtoList(robCategoryEntityList));
    }

    @Override
    public DubboResult<List<RobCategoryDto>> getCategoryPage(String name, String title, Integer offset, Integer pageSize) {
        List<RobCategoryEntity> robCategoryEntityList = robCategoryService.getCategoryPage(name, title, offset, pageSize);
        return DubboResult.successResult(robCategoryEntityListToDtoList(robCategoryEntityList));
    }

    @Override
    public DubboResult<Integer> countByNameAndTitle(String name, String title) {
        return DubboResult.successResult(robCategoryService.countByNameAndTitle(name, title));
    }

    @Override
    public DubboResult<Boolean> deleteById(Long id) {
        return DubboResult.successResult(robCategoryService.deleteById(id));
    }

    @Override
    public DubboResult<Boolean> insertCategory(RobCategoryDetailDto robCategoryDetailDto) {
        return DubboResult.successResult(robCategoryService.insertCategory(robCategoryDetailDto));
    }

    @Override
    public DubboResult<Boolean> batchDeleteCategoryActivityRelation(Long categoryId, List<Long> activityIds) {
        return DubboResult.successResult(robCategoryService.batchDeleteCategoryActivityRelation(categoryId, activityIds));
    }

    @Override
    public DubboResult<Boolean> batchUpdateRobCategoryActivityRelationPayload(RobCategoryDetailDto robCategoryDetailDto) {
        Long categoryId = robCategoryDetailDto.getCategoryId();
        if (categoryId == null)
            DubboResult.failResult("分类id不能为空");
        return DubboResult.successResult(robCategoryService.batchUpdateRobCategoryActivityRelationPayload(robCategoryDetailDto));
    }


    /**
     * 把RobCategoryEntity集合转成RobCategoryDto集合
     *
     * @param robCategoryEntityList
     * @return
     */
    private List<RobCategoryDto> robCategoryEntityListToDtoList(List<RobCategoryEntity> robCategoryEntityList) {
        List<RobCategoryDto> robCategoryDtoList = new ArrayList<>();
        if (CollectionUtils.isEmpty(robCategoryEntityList))
            return robCategoryDtoList;

        for (RobCategoryEntity robCategoryEntity : robCategoryEntityList) {
            robCategoryDtoList.add(robCategoryEntityToDto(robCategoryEntity));
        }
        return robCategoryDtoList;
    }

    /**
     * 把RobCategoryEntity转成RobCategoryDto
     *
     * @param robCategoryEntity
     * @return
     */
    private RobCategoryDto robCategoryEntityToDto(RobCategoryEntity robCategoryEntity) {
        return new RobCategoryDto(robCategoryEntity.getId(), robCategoryEntity.getTitle(), robCategoryEntity.getName());
    }
}
