package cn.com.duiba.activity.center.biz.remoteservice.impl.stock;

import cn.com.duiba.activity.center.api.dto.chaos.ActPreStockDto;
import cn.com.duiba.activity.center.api.remoteservice.stock.RemoteActStockConsumerService;
import cn.com.duiba.activity.center.biz.bo.stock.ActStockConsumerBo;
import cn.com.duiba.service.exception.BusinessException;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

/**
 * Created by wenqi.huang on 16/5/23.
 */
@Service
public class RemoteActStockConsumerServiceImpl implements RemoteActStockConsumerService {
    @Resource
    private ActStockConsumerBo actStockConsumerBo;

    @Override
    public void consumeActStock(Long prizeId, String bizId, String bizSource, Long appId) throws BusinessException {
        actStockConsumerBo.consumeActStock(prizeId, bizId, bizSource, appId);
    }

    @Override
    public void paybackActStock(String bizId, String bizSource) throws BusinessException {
        actStockConsumerBo.paybackActStock(bizId, bizSource);
    }

    @Override
    public ActPreStockDto findActValidStock(Long relationPrizeId, String relationType, Long appId) {
        return actStockConsumerBo.findActValidStock(relationPrizeId, relationType, appId);
    }
}
