package cn.com.duiba.activity.center.biz.service;

import cn.com.duiba.service.domain.dataobject.CouponDO;
import cn.com.duiba.service.domain.vo.ItemKey;

public interface GoodsService {

	/**
	 * 是否是商品中心优惠券
	 * 
	 * @param itemKey
	 * @return
	 */
	public boolean isGoodsCoupon(ItemKey itemKey);
	
	/**
	 * 获取一张券
	 * @param itemKey
	 * @param consumerId
	 * @param bizNum
	 * @return
	 */
	public CouponDO getOneCoupon(ItemKey itemKey, Long consumerId, String bizNum) throws Exception;
	
	/**
	 * 返还一张券
	 * @param couponId
	 * @param itemKey
	 * @param bizNum
	 */
	public void returnOneCoupon(long couponId, ItemKey itemKey, String bizNum) throws Exception;

}
