package cn.com.duiba.activity.center.biz.service.activity_brick;

import java.util.List;
import java.util.Map;

import cn.com.duiba.activity.center.api.dto.activity_brick.PopupActivityBrickDto;

/** 
 * ClassName:PopupActivityBrickService.java <br/>
 * @author  gey 
 * @date 创建时间：2016年10月12日 下午3:08:07 
 * @version 1.0 
 * @parameter  
 * @since   JDK 1.6
 */
public interface PopupActivityBrickService {

	/**
	 * 插入签到皮肤
	 * @param PopupActivityBrickDto brick
	 */
	public PopupActivityBrickDto insert(PopupActivityBrickDto brick);

	/**
	 * 编辑签到皮肤
	 * @param PopupActivityBrickDto brick
	 * @return 操作结果
	 */
	public Integer update(PopupActivityBrickDto brick);

	/**
	 * 根据Id查询签到皮肤
	 * @param Integer id
	 * @return 签到皮肤
	 */
	public PopupActivityBrickDto findById(Long id);

	/**
	 * 删除签到皮肤
	 * @param id 皮肤ID
	 * @return 操作接口
	 */
	public Integer deleteById(Long id);

	/**
	 * 展示签到皮肤
	 * @param id 皮肤ID
	 * @return 操作接口
	 */
	public Integer showBrick(Long id);

	/**
	 * 隐藏签到皮肤
	 * @param id 皮肤ID
	 * @return 操作接口
	 */
	public Integer hiddenBrick(Long id);

	/**
	 * 查询皮肤list
	 * @param id 签到ID
	 * @return 操作结果
	 */
	public List<PopupActivityBrickDto> findPage(Map<String, Object> paramMap);

	/**
	 * 查询皮肤满足条件的总条数
	 * @param map
	 * @return 操作结果
	 */
	public Long findPageCount(Map<String, Object> paramMap);

	/**
	 * 根据Name查询签到皮肤
	 * @param Integer id
	 * @return 签到皮肤
	 */
	public PopupActivityBrickDto findByName(Integer type, String name);
	
	public List<PopupActivityBrickDto> findByCondition(Long appId, String name, Integer offset, Integer max);

    public Long findByConditionCount(Long appId, String name);

    public Integer updateLayoutBrickPosition(Long id, Integer position);
}