package cn.com.duiba.activity.center.biz.service.commonactivity.impl;

import cn.com.duiba.activity.center.biz.dao.game.DuibaQuestionAnswerDao;
import cn.com.duiba.activity.center.biz.entity.game.DuibaQuestionAnswerEntity;
import cn.com.duiba.activity.center.biz.service.commonactivity.ActivityToolService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 答题.
 */
@Service("duibaQuestionAnswerToolServiceImpl")
public class DuibaQuestionAnswerToolServiceImpl extends ActivityToolService.ActivityToolServiceAdapter {

    @Autowired
    private DuibaQuestionAnswerDao duibaQuestionAnswerDao;

    @Override
    public String getTitle(Long activityId) {
        if (activityId == null) {
            throw new RuntimeException("参数不全");
        }
        DuibaQuestionAnswerEntity entity = duibaQuestionAnswerDao.find(activityId);
        if (entity == null || entity.getDeleted()) {
            throw new RuntimeException("活动不存在");
        }
        return entity.getTitle();
    }

}
