package cn.com.duiba.activity.center.biz.service.creditgame;

import java.util.List;

import cn.com.duiba.activity.center.biz.entity.creditgame.CreditGameEntity;
import cn.com.duiba.activity.center.biz.service.GenericCURDService;

/**
 * 积分游戏Bo接口
 * @author jyc
 * @since 2016-09-05
 */
public interface CreditGameService extends GenericCURDService<CreditGameEntity,Long> {

    /**
     * 根据ID获取积分游戏实体
     * @param creditGameId
     * @return 积分游戏实体
     */
    CreditGameEntity getCreditGameById(Long creditGameId);
    
    List<CreditGameEntity> findPage(String title,Integer offset,Integer max);

    Long findCount(String title);
    
    /**
     * 
     * updateStatus:更新状态. <br/>
     *
     * @author wubo
     * @param id 活动id
     * @param status 状态
     * @return
     * @since JDK 1.6
     */
    int updateStatus(Long id,byte status);
    
    /**
     * 
     * findAutoOff:查询应该自动下架的活动id. <br/>
     *
     * 条件:1.到了自动下架时间 2.状态为开启的.3.非删除的
     * @author wubo
     * @return
     * @since JDK 1.6
     */
    List<Long> findAutoOff();
}
