package cn.com.duiba.activity.center.biz.service.creditgame.impl;

import cn.com.duiba.activity.center.biz.dao.GenericCURDDao;
import cn.com.duiba.activity.center.biz.dao.creditgame.CreditGameSkinDao;
import cn.com.duiba.activity.center.biz.entity.creditgame.CreditGameSkinEntity;
import cn.com.duiba.activity.center.biz.service.creditgame.CreditGameSkinService;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.activity.center.biz.service.AbstractGenericCURDService;

/**
 * 积分游戏皮肤Service实现类
 * @author jyc
 * @since 2016-09-06
 */
@Service
public class CreditGameSkinServiceImpl extends AbstractGenericCURDService<CreditGameSkinEntity,Long> implements CreditGameSkinService {

    @Autowired
    private CreditGameSkinDao creditGameSkinDao;

    protected  GenericCURDDao<CreditGameSkinEntity, Long> getDao(){
        return creditGameSkinDao;
    }

    @Override
    public CreditGameSkinEntity queryByCreditGameId(Long creditGameId) {
        return this.creditGameSkinDao.selectByCreditGameId(creditGameId);
    }


}
