package cn.com.duiba.activity.center.biz.service.direct.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;

import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import cn.com.duiba.activity.center.api.dto.direct.ActivityBlackList4DeveloperDto;
import cn.com.duiba.activity.center.biz.dao.direct.DeveloperActivityBlackDao;
import cn.com.duiba.activity.center.biz.service.direct.DeveloperActBlackService;
import cn.com.duiba.activity.center.biz.support.CacheConstants;
import cn.com.duiba.wolf.cache.CacheClient;

@Service
public class DeveloperActBlackServiceImpl implements DeveloperActBlackService {

    private static Logger             log = LoggerFactory.getLogger(DeveloperActBlackServiceImpl.class);
    @Resource
    private DeveloperActivityBlackDao developerActivityBlackDao;
    @Resource
    private CacheClient               memcachedClient;

    @Override
    public List<ActivityBlackList4DeveloperDto> createBlackList(List<ActivityBlackList4DeveloperDto> blacks) {
        if (blacks == null) return null;
        List<ActivityBlackList4DeveloperDto> rs = new ArrayList<ActivityBlackList4DeveloperDto>();
        for (ActivityBlackList4DeveloperDto black : blacks) {
            int num = this.developerActivityBlackDao.query(black);// 查询表中是否已存在这条数据,若有,则不再进行添加
            if (num == 0) {
                this.developerActivityBlackDao.insert(black);
                this.removeBlackCache(black);// 删除缓存
                rs.add(black);
            }
        }
        return rs;
    }

    @Override
    public ActivityBlackList4DeveloperDto insertActivityBalack(ActivityBlackList4DeveloperDto black) {
        if (black == null) return null;

        int num = this.developerActivityBlackDao.query(black);// 查询表中是否已存在这条数据,若有,则不再进行添加
        if (num == 0) {
            this.developerActivityBlackDao.insert(black);
            this.removeBlackCache(black);// 删除缓存
            return black;
        }
        return null;
    }

    @Override
    public Boolean removeBlack(Long id) {
        try {
            ActivityBlackList4DeveloperDto black = this.developerActivityBlackDao.find(id);

            if (black != null) {
                this.developerActivityBlackDao.remove(id);
                this.removeBlackCache(black);
                return true;
            } else {
                log.error("删除黑名单失败,该id不存在");
            }
        } catch (Exception e) {
            log.error("删除黑名单失败," + e);
        }

        return false;

    }

    @Override
    public List<ActivityBlackList4DeveloperDto> queryByActivity(Long activityId, Integer activityType, Integer offset,
                                                                Integer max) {
        if (activityId == null || activityType == null) return null;
        if (offset == null || offset < 0) offset = 0;
        if (max == null || max <= 0) max = 10;
        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("activityId", activityId);
        paramMap.put("activityType", activityType);
        paramMap.put("offset", offset);
        paramMap.put("max", max);
        return this.developerActivityBlackDao.queryByActivity(paramMap);
    }

    @Override
    public Integer queryCountByActivity(Long activityId, Integer activityType) {
        return this.developerActivityBlackDao.queryCountByActivity(activityId, activityType);
    }

    @Override
    public Integer query(ActivityBlackList4DeveloperDto black) {
        return this.developerActivityBlackDao.query(black);
    }

    @Override
    public void removeBlackCache(ActivityBlackList4DeveloperDto black) {
        this.memcachedClient.remove(getBlackCacheKey(black));
        memcachedClient.remove(getBlackCacheKey(black.getDeveloperId(), black.getActivityType()));
    }

    @Override
    public void setBlackCache(ActivityBlackList4DeveloperDto black, Boolean value) {
        this.memcachedClient.set(getBlackCacheKey(black), value, 300);// 缓存时间设置300s
    }

    /**
     * 获取key
     *
     * @param black
     * @return
     */
    public String getBlackCacheKey(ActivityBlackList4DeveloperDto black) {
        return CacheConstants.KEY_BLACK + black.getDeveloperId() + "_" + black.getActivityId() + "_"
               + black.getActivityType();
    }

    @Override
    public Boolean getBlackCache(ActivityBlackList4DeveloperDto black) {
        return this.memcachedClient.get(getBlackCacheKey(black));
    }

    @Override
    public List<Long> queryActivityIdsByDeveloperId(Long developerId, Integer activityType) {
        List<Long> activityIdList = memcachedClient.get(getBlackCacheKey(developerId, activityType));
        if (CollectionUtils.isEmpty(activityIdList)) {
            activityIdList = developerActivityBlackDao.queryActivityIdsByDeveloperId(developerId, activityType);
            memcachedClient.set(getBlackCacheKey(developerId, activityType), activityIdList, 300);
        }
        return activityIdList;
    }

    private String getBlackCacheKey(Long developerId, Integer activityType) {
        return CacheConstants.KEY_BLACK + developerId + "-" + activityType;
    }

    @Override
    public Boolean isExist(Long activityId, Integer activityType, Long developerId) {
        ActivityBlackList4DeveloperDto dto = new ActivityBlackList4DeveloperDto();
        dto.setActivityId(activityId);
        dto.setActivityType(activityType);
        dto.setDeveloperId(developerId);
        Boolean exist = getBlackCache(dto);
        if (null == exist) {
            Integer result = query(dto);
            exist = result.intValue() > 0;
            setBlackCache(dto, exist);
        }
        return exist;
    }
}
