package cn.com.duiba.activity.center.biz.service.game.impl;

import cn.com.duiba.activity.center.api.dto.game.DuibaQuestionStockManualChangeDto;
import cn.com.duiba.activity.center.biz.dao.game.DuibaQuestionStockManualChangeDao;
import cn.com.duiba.activity.center.biz.entity.game.DuibaQuestionStockManualChangeEntity;
import cn.com.duiba.activity.center.biz.service.game.DuibaQuestionStockManualChangeService;
import cn.com.duiba.wolf.utils.BeanUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;

/**
 * Created by wenqi.huang on 16/6/1.
 */
@Service
public class DuibaQuestionStockManualChangeServiceImpl implements DuibaQuestionStockManualChangeService {
    @Resource
    private DuibaQuestionStockManualChangeDao duibaQuestionStockManualChangeDao;

    @Override
    public List<DuibaQuestionStockManualChangeDto> findByStockId(Long gameStockId) {
        return BeanUtils.copyList(duibaQuestionStockManualChangeDao.findByStockId(gameStockId), DuibaQuestionStockManualChangeDto.class);
    }

    @Override
    public void addBatch(List<DuibaQuestionStockManualChangeDto> list) {
        duibaQuestionStockManualChangeDao.addBatch(BeanUtils.copyList(list, DuibaQuestionStockManualChangeEntity.class));
    }

    @Override
    public void add(DuibaQuestionStockManualChangeDto questionStockManualChangeDO) {
        DuibaQuestionStockManualChangeEntity e = BeanUtils.copy(questionStockManualChangeDO, DuibaQuestionStockManualChangeEntity.class);
        duibaQuestionStockManualChangeDao.add(e);
        questionStockManualChangeDO.setId(e.getId());
    }
}
