/**
 * Project Name:activity-center-biz File Name:BaseSerice.java Package
 * Name:cn.com.duiba.activity.center.biz.service.gamecenter.impl Date:2016年11月9日下午5:42:00 Copyright (c) 2016,
 * duiba.com.cn All Rights Reserved.
 */

package cn.com.duiba.activity.center.biz.service.gamecenter.impl;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.activity.center.api.dto.direct.ActivityBlackList4DeveloperDto;
import cn.com.duiba.activity.center.api.dto.direct.DuibaActivityAppSpecifyNewDto;
import cn.com.duiba.activity.center.api.dto.gamecenter.DefinedActivityTypesDto;
import cn.com.duiba.activity.center.biz.dao.gamecenter.GameCenterResourceLocationDao;
import cn.com.duiba.activity.center.biz.entity.gamecenter.GameCenterResourceLocationEntity;
import cn.com.duiba.activity.center.biz.entity.littlegame.LittleGameEntity;
import cn.com.duiba.activity.center.biz.service.direct.DeveloperActBlackService;
import cn.com.duiba.activity.center.biz.service.direct.DuibaActivityAppSpecifyNewService;
import cn.com.duiba.activity.center.biz.service.gamecenter.ActivityShieldService;
import cn.com.duiba.activity.center.biz.service.gamecenter.GameCenterException;
import cn.com.duiba.service.domain.dataobject.AppDO;
import cn.com.duiba.service.remoteservice.RemoteAppService;

/**
 * ClassName:BaseSerice <br/>
 * Function: TODO ADD FUNCTION. <br/>
 * Reason: TODO ADD REASON. <br/>
 * Date: 2016年11月9日 下午5:42:00 <br/>
 *
 * @author Zhuzhiyong
 * @version
 * @see
 * @since JDK 1.6
 */
@Service
class GameCenterCommonSerice {

    /** The Constant log. */
    private static final Logger               log = LoggerFactory.getLogger(GameCenterCommonSerice.class);

    /** The remote app service. */
    @Autowired
    private RemoteAppService                  remoteAppService;

    /** The developer act black service. */
    @Autowired
    private DeveloperActBlackService          developerActBlackService;

    /** The duiba activity app specify new service. */
    @Autowired
    private DuibaActivityAppSpecifyNewService duibaActivityAppSpecifyNewService;

    /** The game center shield service. */
    @Autowired
    private ActivityShieldService             gameCenterShieldService;

    /** The game center resource location dao. */
    @Autowired
    private GameCenterResourceLocationDao     gameCenterResourceLocationDao;

    /**
     * Find developer id by app id.
     *
     * @param appId the app id
     * @return the long
     */
    public Long findDeveloperIdByAppId(Long appId) {
        AppDO appDO = remoteAppService.find(appId);
        if (appDO == null) {
            log.error("appId is invalid: no record found: {}", appId);
            return null;
        }
        return appDO.getDeveloperId();
    }

    /**
     * 开启了黑名单，并且在黑名单中.
     *
     * @param littleGameEntity the little game entity
     * @param developerId the developer id
     * @return true, if successful
     */
    public boolean filterByActivityBlacklist(LittleGameEntity littleGameEntity, Long developerId) {
        return littleGameEntity.isOpenSwitch(LittleGameEntity.SWITCHES_DEV_BLACKLIST)
               && developerActBlackService.isExist(littleGameEntity.getId(),
                                                   ActivityBlackList4DeveloperDto.TypeDuibaLittleGame, developerId).booleanValue();
    }

    /**
     * 开启了定向,但app不在定向范围内.
     *
     * @param littleGameEntity the little game entity
     * @param appId the app id
     * @return true, if successful
     */
    public boolean filterBySpecify(LittleGameEntity littleGameEntity, Long appId) {
        return littleGameEntity.isOpenSwitch(LittleGameEntity.SWITCHES_DIRECT)
               && duibaActivityAppSpecifyNewService.findAppSpecifyByActivityIdAndAppIdAndActivityType(littleGameEntity.getId(),
                                                                                                      appId, DuibaActivityAppSpecifyNewDto.ACTIVITY_LITTLE_GAME) == null;
    }

    /**
     * 被开发者屏蔽.
     *
     * @param appId the app id
     * @param littleGameId the little game id
     * @return true, if successful
     */
    public boolean filterByShield(Long appId, Long littleGameId) {
        return gameCenterShieldService.findShield(appId, DefinedActivityTypesDto.LITTLE_GAME, littleGameId) != null;
    }

    /**
     * 根据locationName查询id.
     *
     * @param name the name
     * @return the long
     * @throws GameCenterException the game center exception
     */
    public Long findLocationIdByName(String name) throws GameCenterException {
        GameCenterResourceLocationEntity entity = gameCenterResourceLocationDao.findResourceLocationByName(name);
        if (entity == null) {
            throw new GameCenterException("No this location found:" + name);
        }
        return entity.getId();
    }

}
