/**
 * Project Name:activity-center-biz File Name:MultiActivityQueryingServiceImpl.java Package
 * Name:cn.com.duiba.activity.center.biz.service.gamecenter.impl Date:2016年10月20日下午7:28:45 Copyright (c) 2016,
 * duiba.com.cn All Rights Reserved.
 */

package cn.com.duiba.activity.center.biz.service.gamecenter.impl;

import javax.annotation.Resource;

import org.springframework.stereotype.Service;

import cn.com.duiba.activity.center.api.dto.duibaactivity.DuibaActivityDto;
import cn.com.duiba.activity.center.api.dto.game.DuibaQuestionAnswerDto;
import cn.com.duiba.activity.center.api.dto.gamecenter.DefinedActivityTypesDto;
import cn.com.duiba.activity.center.api.dto.guess.DuibaGuessDto;
import cn.com.duiba.activity.center.api.dto.hdtool.DuibaHdtoolDto;
import cn.com.duiba.activity.center.api.dto.ngame.DuibaNgameDto;
import cn.com.duiba.activity.center.api.dto.quizz.DuibaQuizzDto;
import cn.com.duiba.activity.center.api.dto.seconds_kill.DuibaSecondsKillActivityDto;
import cn.com.duiba.activity.center.api.dto.singlelottery.DuibaSingleLotteryDto;
import cn.com.duiba.activity.center.biz.service.direct.DeveloperActBlackService;
import cn.com.duiba.activity.center.biz.service.direct.DuibaActivityAppSpecifyNewService;
import cn.com.duiba.activity.center.biz.service.duibaactivity.DuibaActivityAppSpecifyService;
import cn.com.duiba.activity.center.biz.service.duibaactivity.DuibaActivityService;
import cn.com.duiba.activity.center.biz.service.game.DuibaQuestionAnswerAppSpecifyService;
import cn.com.duiba.activity.center.biz.service.game.DuibaQuestionAnswerService;
import cn.com.duiba.activity.center.biz.service.gamecenter.GameCenterException;
import cn.com.duiba.activity.center.biz.service.gamecenter.GeneralActivityItem;
import cn.com.duiba.activity.center.biz.service.gamecenter.MultiActivityQueryingService;
import cn.com.duiba.activity.center.biz.service.guess.DuibaGuessAppSpecifyService;
import cn.com.duiba.activity.center.biz.service.guess.DuibaGuessService;
import cn.com.duiba.activity.center.biz.service.hdtool.DuibaHdtoolService;
import cn.com.duiba.activity.center.biz.service.ngame.DuibaNgameAppSpecifyService;
import cn.com.duiba.activity.center.biz.service.ngame.DuibaNgameService;
import cn.com.duiba.activity.center.biz.service.quizz.DuibaQuizzAppSpecifyService;
import cn.com.duiba.activity.center.biz.service.quizz.DuibaQuizzService;
import cn.com.duiba.activity.center.biz.service.seconds_kill.DuibaSecondsKillActivityAppSpecifyService;
import cn.com.duiba.activity.center.biz.service.seconds_kill.DuibaSecondsKillActivityService;
import cn.com.duiba.activity.center.biz.service.singlelottery.DuibaSingleLotteryService;
import cn.com.duiba.service.domain.dataobject.AppDO;
import cn.com.duiba.service.domain.dataobject.DuibaSeckillDO;
import cn.com.duiba.service.remoteservice.RemoteAppService;
import cn.com.duiba.service.remoteservice.RemoteDuibaSeckillAppSpecifyService;
import cn.com.duiba.service.remoteservice.RemoteDuibaSeckillService;

/**
 * ClassName:MultiActivityQueryingServiceImpl <br/>
 * Function: TODO ADD FUNCTION. <br/>
 * Reason: TODO ADD REASON. <br/>
 * Date: 2016年10月20日 下午7:28:45 <br/>
 * 
 * @author Zhuzhiyong
 * @version
 * @since JDK 1.6
 * @see
 */
@Service
public class MultiActivityQueryingServiceImpl implements MultiActivityQueryingService {

    @Resource
    private DuibaHdtoolService                   duibaHdtoolService;                       // 活动工具
    @Resource
    private DuibaActivityService                 duibaActivityService;                     // 活动专题
    @Resource
    private DuibaSingleLotteryService            duibaSingleLotteryService;                // 单品抽奖
    @Resource
    private DuibaSecondsKillActivityService      duibaSecondsKillActivityService;          // 秒杀专题
    @Resource
    DuibaSecondsKillActivityAppSpecifyService    duibaSecondsKillActivityAppSpecifyService;
    @Resource
    private DuibaNgameService                    duibaNgameService;                        // 新游戏
    @Resource
    private DuibaNgameAppSpecifyService          duibaNgameAppSpecifyService;
    @Resource
    private DuibaQuestionAnswerService           duibaQuestionAnswerService;               // 答题
    @Resource
    private DuibaQuestionAnswerAppSpecifyService duibaQuestionAnswerAppSpecifyService;
    @Resource
    private RemoteDuibaSeckillService            duibaSeckillService;                      // 秒杀活动
    @Resource
    private RemoteDuibaSeckillAppSpecifyService  remoteDuibaSeckillAppSpecifyService;
    @Resource
    private DuibaQuizzService                    duibaQuizzService;                        // 测试题
    @Resource
    private DuibaQuizzAppSpecifyService          duibaQuizzAppSpecifyService;
    @Resource
    private DuibaGuessService                    duibaGuessService;                        // 竞猜
    @Resource
    private DuibaGuessAppSpecifyService          duibaGuessAppSpecifyService;
    @Resource
    private RemoteAppService                     remoteAppService;
    @Resource
    private DeveloperActBlackService             developerActBlackService;
    @Resource
    private DuibaActivityAppSpecifyNewService    duibaActivityAppSpecifyNewService;
    @Resource
    private DuibaActivityAppSpecifyService       duibaActivityAppSpecifyService;

    @Override
    public GeneralActivityItem findActivityByTypeAndIdWithFilter(Integer activityType,
                                                                 Long activityId) throws GameCenterException {
        return findActivityByTypeAndIdWithFilterAll(activityType, activityId, null);
    }

    @Override
    public GeneralActivityItem findActivityByTypeAndIdWithFilter(Integer activityType, Long activityId,
                                                                 Long appId) throws GameCenterException {

        return findActivityByTypeAndIdWithFilterAll(activityType, activityId, appId);
    }

    private GeneralActivityItem findActivityByTypeAndIdWithFilterAll(Integer activityType, Long activityId,
                                                                     Long appId) throws GameCenterException {

        Long developerId = null;
        if (appId != null) {
            AppDO appDO = remoteAppService.find(appId);
            if (appDO == null) {
                throw new GameCenterException(ErrorMsg.APP_NOT_EXIST);
            }
            developerId = appDO.getDeveloperId();
        }
        String title, bannerImg, recImg, iconImg, description;
        switch (activityType.intValue()) {
            case DefinedActivityTypesDto.NEW_HDTOOL: // 活动工具
                DuibaHdtoolDto duibaHdtoolDto = duibaHdtoolService.find(activityId);

                // TODO 活动类型
                if (duibaHdtoolDto == null) {
                    throw new GameCenterException(ErrorMsg.ACTIVITY_NOT_EXIST);
                }
                if (duibaHdtoolDto.getStatus().intValue() != DuibaHdtoolDto.STATUS_OPEN) {
                    throw new GameCenterException(ErrorMsg.ACTIVITY_NOT_OPEN);
                }
                title = duibaHdtoolDto.getTitle();
                bannerImg = duibaHdtoolDto.getBannerImage();
                recImg = duibaHdtoolDto.getRecommendImage();
                iconImg = duibaHdtoolDto.getLogo();
                description = duibaHdtoolDto.getDescription();
                if (developerId != null) {
                    // 开启黑名单，且开发者在黑名单中
                    if (duibaHdtoolDto.isOpenSwitch(DuibaHdtoolDto.SWITCHES_DEV_BLACKLIST)
                        && developerActBlackService.isExist(activityId, activityType, developerId)) {
                        throw new GameCenterException(ErrorMsg.ACTIVITY_FILTER_BY_BLACKLIST);
                    }
                }

                if (appId != null) {
                    // 开启了定向活动，但不在定向范围内
                    if (duibaHdtoolDto.isOpenSwitch(DuibaHdtoolDto.SWITCHES_DIRECT)) {
                        if (duibaHdtoolService.findSpecifyByHdToolIdAndApp(activityId, appId) == null) {
                            throw new GameCenterException(ErrorMsg.ACTIVITY__DIRECT_ACTIVITY);
                        }
                    }
                }
                break;
            case DefinedActivityTypesDto.DUIBA_ACTIVITY: // 活动专题
                DuibaActivityDto duibaActivityDto = duibaActivityService.find(activityId);
                if (duibaActivityDto == null) {
                    throw new GameCenterException(ErrorMsg.ACTIVITY_NOT_EXIST);
                }
                if (duibaActivityDto.getStatus().intValue() != DuibaActivityDto.STATUS_STARTUP) {
                    throw new GameCenterException(ErrorMsg.ACTIVITY_NOT_OPEN);
                }

                title = duibaActivityDto.getTitle();
                bannerImg = duibaActivityDto.getIndexBannerImage();
                recImg = duibaActivityDto.getRecommendImage();
                iconImg = duibaActivityDto.getLogo();
                description = duibaActivityDto.getSubtitle();

                if (developerId != null) {
                    // 开启黑名单，且开发者在黑名单中
                    if (duibaActivityDto.isOpenSwitch(DuibaHdtoolDto.SWITCHES_DEV_BLACKLIST)
                        && developerActBlackService.isExist(activityId, activityType, developerId)) {
                        throw new GameCenterException(ErrorMsg.ACTIVITY_FILTER_BY_BLACKLIST);
                    }
                }

                if (appId != null) {
                    // 开启了定向活动，但不在定向范围内
                    if (duibaActivityDto.isOpenSwitch(DuibaHdtoolDto.SWITCHES_DIRECT)) {
                        if (duibaActivityAppSpecifyService.findByDuibaActivityAndApp(activityId, appId) == null) {
                            throw new GameCenterException(ErrorMsg.ACTIVITY__DIRECT_ACTIVITY);
                        }
                    }
                }
                break;
            case DefinedActivityTypesDto.SINGLE_LOTTERY:// 单品抽奖
                DuibaSingleLotteryDto duibaSingleLotteryDto = duibaSingleLotteryService.find(activityId);
                if (duibaSingleLotteryDto == null) {
                    throw new GameCenterException(ErrorMsg.ACTIVITY_NOT_EXIST);
                }
                if (duibaSingleLotteryDto.getStatus().intValue() != DuibaSingleLotteryDto.STATUS_STARTUP) {
                    throw new GameCenterException(ErrorMsg.ACTIVITY_NOT_OPEN);
                }
                title = duibaSingleLotteryDto.getTitle();
                bannerImg = duibaSingleLotteryDto.getBannerImage();
                recImg = duibaSingleLotteryDto.getImage(); // TODO 无推荐图，使用默认图代替
                iconImg = duibaSingleLotteryDto.getLogo();
                description = duibaSingleLotteryDto.getSubtitle();

                if (developerId != null) {
                    // 开启黑名单，且开发者在黑名单中
                    if (duibaSingleLotteryDto.isOpenSwitch(DuibaSingleLotteryDto.SWITCHES_DEV_BLACKLIST)
                        && developerActBlackService.isExist(activityId, activityType, developerId)) {
                        throw new GameCenterException(ErrorMsg.ACTIVITY_FILTER_BY_BLACKLIST);
                    }
                }

                if (appId != null) {
                    // 开启了定向活动，但不在定向范围内
                    if (duibaSingleLotteryDto.isOpenSwitch(DuibaSingleLotteryDto.SWITCHES_DIRECT)) {
                        if (duibaSingleLotteryService.findSpecifyByDuibaSingleLotteryAndApp(activityId,
                                                                                            appId) == null) {
                            throw new GameCenterException(ErrorMsg.ACTIVITY__DIRECT_ACTIVITY);
                        }
                    }
                }

                break;
            case DefinedActivityTypesDto.SECONDS_KILL: // 秒杀专题
                DuibaSecondsKillActivityDto duibaSecondsKillActivityDto = duibaSecondsKillActivityService.find(activityId);
                if (duibaSecondsKillActivityDto == null) {
                    throw new GameCenterException(ErrorMsg.ACTIVITY_NOT_EXIST);
                }
                if (duibaSecondsKillActivityDto.getStatus().intValue() != DuibaSecondsKillActivityDto.STATUS_STARTUP) {
                    throw new GameCenterException(ErrorMsg.ACTIVITY_NOT_OPEN);
                }
                title = duibaSecondsKillActivityDto.getTitle();
                bannerImg = duibaSecondsKillActivityDto.getIndexBannerImage();
                recImg = duibaSecondsKillActivityDto.getRecommendImage();
                iconImg = duibaSecondsKillActivityDto.getLogo();
                description = duibaSecondsKillActivityDto.getNextTitle();

                if (developerId != null) {
                    // 开启黑名单，且开发者在黑名单中
                    if (duibaSecondsKillActivityDto.isOpenSwitch(DuibaSecondsKillActivityDto.SWITCHES_DEV_BLACKLIST)
                        && developerActBlackService.isExist(activityId, activityType, developerId)) {
                        throw new GameCenterException(ErrorMsg.ACTIVITY_FILTER_BY_BLACKLIST);
                    }
                }

                if (appId != null) {
                    // 开启了定向活动，但不在定向范围内
                    if (duibaSecondsKillActivityDto.isOpenSwitch(DuibaSecondsKillActivityDto.SWITCHES_DIRECT)) {
                        if (duibaSecondsKillActivityAppSpecifyService.findByDuibaSecondsKillActivityAndApp(activityId,
                                                                                                           appId) == null) {
                            throw new GameCenterException(ErrorMsg.ACTIVITY__DIRECT_ACTIVITY);
                        }
                    }
                }

                break;
            case DefinedActivityTypesDto.NGAME: // 新游戏
                DuibaNgameDto duibaNgameDto = duibaNgameService.find(activityId);
                if (duibaNgameDto == null) {
                    throw new GameCenterException(ErrorMsg.ACTIVITY_NOT_EXIST);
                }
                if (duibaNgameDto.getGameStatus().intValue() != DuibaNgameDto.STATUS_OPEN) {
                    throw new GameCenterException(ErrorMsg.ACTIVITY_NOT_OPEN);
                }
                title = duibaNgameDto.getTitle();
                bannerImg = duibaNgameDto.getBanner();
                recImg = duibaNgameDto.getRecommendImage();
                iconImg = duibaNgameDto.getLogo();
                description = ""; // TODO 没有描述

                if (developerId != null) {
                    // 开启黑名单，且开发者在黑名单中
                    if (duibaNgameDto.isOpenSwitch(DuibaNgameDto.SWITCHES_DEV_BLACKLIST)
                        && developerActBlackService.isExist(activityId, activityType, developerId)) {
                        throw new GameCenterException(ErrorMsg.ACTIVITY_FILTER_BY_BLACKLIST);
                    }
                }

                if (appId != null) {
                    // 开启了定向活动，但不在定向范围内
                    if (duibaNgameDto.isOpenSwitch(DuibaNgameDto.SWITCHES_DIRECT)) {
                        if (duibaNgameAppSpecifyService.findByGameConfigAndAppId(activityId, appId) == null) {
                            throw new GameCenterException(ErrorMsg.ACTIVITY__DIRECT_ACTIVITY);
                        }
                    }
                }
                break;
            case DefinedActivityTypesDto.QUESTION_ANSWER: // 答题30
                DuibaQuestionAnswerDto duibaQuestionAnswerDto = duibaQuestionAnswerService.find(activityId);

                if (duibaQuestionAnswerDto == null) {
                    throw new GameCenterException(ErrorMsg.ACTIVITY_NOT_EXIST);
                }
                if (duibaQuestionAnswerDto.getStatus().intValue() != DuibaQuestionAnswerDto.STATUS_OPEN) {
                    throw new GameCenterException(ErrorMsg.ACTIVITY_NOT_OPEN);
                }

                title = duibaQuestionAnswerDto.getTitle();
                bannerImg = duibaQuestionAnswerDto.getBanner();
                recImg = duibaQuestionAnswerDto.getRecommendImage();
                iconImg = duibaQuestionAnswerDto.getLogo();
                description = ""; // TODO 没有描述

                if (developerId != null) {
                    // 开启黑名单，且开发者在黑名单中
                    if (duibaQuestionAnswerDto.isOpenSwitch(DuibaQuestionAnswerDto.SWITCHES_DEV_BLACKLIST)
                        && developerActBlackService.isExist(activityId, activityType, developerId)) {
                        throw new GameCenterException(ErrorMsg.ACTIVITY_FILTER_BY_BLACKLIST);
                    }
                }

                if (appId != null) {
                    // 开启了定向活动，但不在定向范围内
                    if (duibaQuestionAnswerDto.isOpenSwitch(DuibaQuestionAnswerDto.SWITCHES_DIRECT)) {
                        if (duibaQuestionAnswerAppSpecifyService.findByQuestionAnswerIdAndAppId(activityId,
                                                                                                appId) == null) {
                            throw new GameCenterException(ErrorMsg.ACTIVITY__DIRECT_ACTIVITY);
                        }
                    }
                }

                break;
            case DefinedActivityTypesDto.DUIBA_SEC_KILL:// 秒杀活动
                DuibaSeckillDO duibaSeckillDO = duibaSeckillService.find(activityId);

                if (duibaSeckillDO == null) {
                    throw new GameCenterException(ErrorMsg.ACTIVITY_NOT_EXIST);
                }
                if (duibaSeckillDO.getStatus().intValue() != DuibaSeckillDO.STATUS_OPEN) {
                    throw new GameCenterException(ErrorMsg.ACTIVITY_NOT_OPEN);
                }

                title = duibaSeckillDO.getTitle();
                bannerImg = duibaSeckillDO.getBanner();
                recImg = duibaSeckillDO.getRecommendImage();
                iconImg = duibaSeckillDO.getLogo();
                description = ""; // TODO 没有描述

                if (developerId != null) {
                    // 开启黑名单，且开发者在黑名单中
                    if (duibaSeckillDO.isOpenSwitch(DuibaSeckillDO.SWITCHES_DEV_BLACKLIST)
                        && developerActBlackService.isExist(activityId, activityType, developerId)) {
                        throw new GameCenterException(ErrorMsg.ACTIVITY_FILTER_BY_BLACKLIST);
                    }
                }

                if (appId != null) {
                    // 开启了定向活动，但不在定向范围内
                    if (duibaSeckillDO.isOpenSwitch(DuibaSeckillDO.SWITCHES_DIRECT)) {
                        if (remoteDuibaSeckillAppSpecifyService.findByDuibaSeckillAndApp(activityId, appId) == null) {
                            throw new GameCenterException(ErrorMsg.ACTIVITY__DIRECT_ACTIVITY);
                        }
                    }
                }

                break;
            case DefinedActivityTypesDto.QUIZZ: // 测试题
                DuibaQuizzDto duibaQuizzDto = duibaQuizzService.find(activityId);

                if (duibaQuizzDto == null) {
                    throw new GameCenterException(ErrorMsg.ACTIVITY_NOT_EXIST);
                }
                if (duibaQuizzDto.getStatus().intValue() != DuibaQuizzDto.STATUS_OPEN) {
                    throw new GameCenterException(ErrorMsg.ACTIVITY_NOT_OPEN);
                }

                title = duibaQuizzDto.getTitle();
                bannerImg = duibaQuizzDto.getBanner();
                recImg = duibaQuizzDto.getRecommendImage();
                iconImg = duibaQuizzDto.getLogo();
                description = ""; // TODO 没有描述

                if (developerId != null) {
                    // 开启黑名单，且开发者在黑名单中
                    if (duibaQuizzDto.isOpenSwitch(DuibaQuizzDto.SWITCHES_DEV_BLACKLIST)
                        && developerActBlackService.isExist(activityId, activityType, developerId)) {
                        throw new GameCenterException(ErrorMsg.ACTIVITY_FILTER_BY_BLACKLIST);
                    }
                }

                if (appId != null) {
                    // 开启了定向活动，但不在定向范围内
                    if (duibaQuizzDto.isOpenSwitch(DuibaQuizzDto.SWITCHES_DIRECT)) {
                        if (duibaQuizzAppSpecifyService.findByDuibaQuizzAndApp(activityId, appId) == null) {
                            throw new GameCenterException(ErrorMsg.ACTIVITY__DIRECT_ACTIVITY);
                        }
                    }
                }
                break;
            case DefinedActivityTypesDto.GUESS: // 竞猜
                DuibaGuessDto duibaGuessDto = duibaGuessService.find(activityId);

                if (duibaGuessDto == null) {
                    throw new GameCenterException(ErrorMsg.ACTIVITY_NOT_EXIST);
                }
                if (duibaGuessDto.getStatus().intValue() != DuibaGuessDto.STATUS_OPEN) {
                    throw new GameCenterException(ErrorMsg.ACTIVITY_NOT_OPEN);
                }

                title = duibaGuessDto.getTitle();
                bannerImg = duibaGuessDto.getBanner();
                recImg = duibaGuessDto.getRecommendImage();
                iconImg = duibaGuessDto.getLogo();
                description = ""; // TODO 没有描述

                if (developerId != null) {
                    // 开启黑名单，且开发者在黑名单中
                    if (duibaGuessDto.isOpenSwitch(DuibaGuessDto.SWITCHES_DEV_BLACKLIST)
                        && developerActBlackService.isExist(activityId, activityType, developerId)) {
                        throw new GameCenterException(ErrorMsg.ACTIVITY_FILTER_BY_BLACKLIST);
                    }
                }

                if (appId != null) {
                    // 开启了定向活动，但不在定向范围内
                    if (duibaGuessDto.isOpenSwitch(DuibaGuessDto.SWITCHES_DIRECT)) {
                        if (duibaGuessAppSpecifyService.findByDuibaGuessAndApp(activityId, appId) == null) {
                            throw new GameCenterException(ErrorMsg.ACTIVITY__DIRECT_ACTIVITY);
                        }
                    }
                }

                break;
            default:
                throw new GameCenterException("Activity type not support: " + activityType.intValue());
        }

        GeneralActivityItem result = new GeneralActivityItem();
        result.setActivityId(activityId);
        result.setActivityType(activityType);
        result.setTitle(title);
        result.setBannerImg(bannerImg);
        result.setRecommendImg(recImg);
        result.setIconImg(iconImg);
        result.setDescription(description);
        return result;
    }

    interface ErrorMsg {

        String ACTIVITY_NOT_EXIST           = "活动不存在";
        String ACTIVITY_NOT_OPEN            = "活动未开启";
        String ACTIVITY_FILTER_BY_BLACKLIST = "被黑名单过滤";
        String ACTIVITY__DIRECT_ACTIVITY    = "定向活动";
        String APP_NOT_EXIST                = "APP不存在";
    }
}
