/**
 * Project Name:activity-center-biz
 * File Name:ActivityPrizeOptionService.java
 * Package Name:cn.com.duiba.activity.center.biz.service.prize
 * Date:2016年7月26日下午4:01:31
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.activity.center.biz.service.prize;

import java.util.List;

import cn.com.duiba.activity.center.api.dto.prize.ActivityPrizeOptionDto;

/**
 * ClassName:ActivityPrizeOptionService <br/>
 * Function: TODO ADD FUNCTION. <br/>
 * Reason:	 TODO ADD REASON. <br/>
 * Date:     2016年7月26日 下午4:01:31 <br/>
 * @author   zp
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
public interface ActivityPrizeOptionService {

    public ActivityPrizeOptionDto find(Long id);
    /**
     * 编辑或保存
     * @author zp
     * @param activityPrizeOptionDto
     * @return
     * @since JDK 1.6
     */
    public Long saveOrUpdateOption(ActivityPrizeOptionDto activityPrizeOptionDto);
    
    /**
     * 删除
     * @author zp
     * @param id
     * @return
     * @since JDK 1.6
     */
    public Boolean deleteOption(Long id);
    
    /**
     * 根据活动id查询奖项
     * @author zp
     * @param configId
     * @return
     * @since JDK 1.6
     */
    public List<ActivityPrizeOptionDto> queryActivityOptionsByConfigId(Long configId,String activityType);
    
    /**
     * 根据活动id查询奖项
     * @param configIds
     * @param activityType
     * @param prizeType
     * @return
     */
    public List<ActivityPrizeOptionDto> queryCouponActivityOptionsByIds(List<Long> configIds,String activityType, String prizeType);
    
    /**
     * 批量查询奖项
     * @author wubo
     * @param configIds
     * @param activityType
     * @return
     * @since JDK 1.6
     */
    public List<ActivityPrizeOptionDto> queryActivityOptionsByConfigIds(List<Long> configIds,String activityType);
    
    /**
     * 根据活动类型查询活动奖项
     * queryActivityOptionsByActivityType. <br/>
     *
     * @author wubo
     * @param activityType
     * @return
     * @since JDK 1.6
     */
    public List<ActivityPrizeOptionDto> queryActivityOptionsByActivityType(String activityType,Integer offset,Integer max);
    
    /**
     * 
     * queryCountByActivityType:查询某个活动类型的数量. <br/>
     *
     * @author wubo
     * @param activityType
     * @return
     * @since JDK 1.6
     */
    public Long queryCountByActivityType(String activityType);
    
    /**
     * 
     * queryRandomByActivityType:随机查询特定个数的某个类型的奖项.并排除某些特定的id. <br/>
     *
     * @author wubo
     * @param activityType 类型
     * @param number 个数
     * @param ids 过滤的id
     * @return list
     * @since JDK 1.6
     */
    public List<ActivityPrizeOptionDto> queryRandomByActivityType(String activityType,int number,List<Long> ids);
    
}

