package cn.com.duiba.activity.center.biz.service.rob;

import java.util.List;

/**
 * 功能描述:今日必抢分类活动相关操作接口service
 *
 * @author sunchangji
 * @date 2016/10/19
 */
public interface RobActivityService {

    /**
     * 新增活动关联数据
     *
     * @param activityId     活动id
     * @param categoryIdList 关联的活动id集合
     * @return
     */
    Boolean insertTodayRobActivity(Long activityId, List<Long> categoryIdList);

    /**
     * 根据活动id查询活动所属的全部分类id集合
     *
     * @param activityId 活动id
     * @return
     */
    List<Long> getCategoryIdsByActivityId(Long activityId);

    /**
     * 删除分类与活动关联表数据
     * 1.先根据活动删除掉活动与分类中间表数据
     * 2.在活动与分类关联表中新增活动关联的分类
     *
     * @param activityId     今日必抢活动id
     * @param categoryIdList 关联的分类id列表
     * @return
     */
    Boolean deleteRobCategoryActivityRelation(Long activityId, List<Long> categoryIdList);

}
