package cn.com.duiba.activity.center.biz.service.rob;

import cn.com.duiba.activity.center.api.dto.rob.category.RobCategoryBarAppRelationDto;
import cn.com.duiba.activity.center.biz.entity.robcategory.RobCategoryBarAppRelationEntity;

import java.util.List;

/**
 * 功能描述:分类栏与应用关联表操作接口定义
 * (也称分类栏定向实体)
 *
 * @author sunchangji
 * @date 2016/10/19
 */
public interface RobCategoryBarAppRelationService {

    /**
     * 查询全部定向表列表数据，并对数据进行按分类栏id分组
     *
     * @return
     */
    List<RobCategoryBarAppRelationDto> getRobCategoryBarAppList();

    /**
     * 根据分类栏id删除分类栏定向
     *
     * @param barId 分类栏id
     * @return
     */
    Boolean deleteById(Long barId);

    /**
     * 根据分类栏id批量删除分类栏定向
     *
     * @param barIds 分类栏id集合
     * @return
     */
    Boolean batchDeleteById(List<Long> barIds);

    /**
     * 批量新增分类栏定向
     *
     * @param batchList 新增数据集合
     * @return
     */
    Boolean batchInsertBarAppRelation(List<RobCategoryBarAppRelationDto> batchList);

    /**
     * 批量更新
     *
     * @param batchList
     * @return
     */
    Boolean batchUpdateBarAppRelation(List<RobCategoryBarAppRelationDto> batchList);

    /**
     * 批量删除分类栏对应下的app
     *
     * @param appIds 应用id集合
     * @return
     */
    Boolean batchDeleteBarAppRelation(List<Long> appIds);

    /**
     * 根据appId查询
     *
     * @param appId 应用id
     * @return
     */
    RobCategoryBarAppRelationEntity getByAppId(Long appId);
}
