package cn.com.duiba.activity.center.biz.support;

import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Set;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 定义缓存的key,为了防止和其他项目中的key重复,在每个值前面加上子模块名前缀 Created by wenqi.huang on 16/4/25.
 */
public class CacheConstants {
    
    private static Logger log = LoggerFactory.getLogger(CacheConstants.class);

    public static final String KEY_APP_MANUAL_LOTTERY_BY_ID         = "activity-appManualLotteryById_";
    public static final String KEY_NGAME_ORDERS_APP_BY_CONSUMER_ID_ORDERID         = "activity-NGAME_ORDERS_APP_BY_CONSUMER_ID_ORDERID_";
    public static final String KEY_QUESTION_ANSWER_APP_SPECIFY_BY_QID_AID         = "activity-questionAnswerAppSpeByQidAid_";
    public static final String KEY_DUIBA_QUESTION_ANSWER_BRICK_NOCONTENT_BY_ID        = "activity-duibaQuestionAnswerBrickNoContentById_";
    public static final String KEY_DUIBA_QUESTION_ANSWER_BRICK_CONTENT_BY_ID        = "activity-duibaQuestionAnswerBrickContentById_";
    public static final String KEY_DUIBA_QUESTION_ANSWER_OPTIONS_BY_ID        = "activity-duibaQuestionAnswerOptionsById_";
    public static final String KEY_DUIBA_QUESTION_ANSWER_OPTIONS_BY_QID        = "activity-duibaQuestionAnswerOptionsByQid_";
    public static final String KEY_DUIBA_QUESTION_ANSWER_ORDERS_EXTRA_BY_ORDERID        = "activity-duibaQuestionAnswerOrdersExtraByOrderId_";
    public static final String KEY_DUIBA_QUESTION_ANSWER_ORDERS_BY_ID        = "activity-duibaQuestionAnswerOrdersById_";
    public static final String KEY_DUIBA_QUESTION_ANSWER_BY_ID        = "activity-duibaQuestionAnswerById_";
    public static final String KEY_DUIBA_QUESTION_RECORD_BY_QBANKID        = "activity-duibaQuestionRecordByQBandId_";
    public static final String KEY_CREDITS_HDTOOL_ORDERS_BY_ID        = "activity-creditsHdtoolOrdersById_";
    public static final String KEY_DUIBA_HDTOOL_BY_ID        = "activity-duibaHdtoolById_";
    public static final String KEY_DUIBA_HDTOOL_OPTIONS_BY_ID        = "activity-duibaHdtoolOptionsById_";
    public static final String KEY_DUIBA_HDTOOL_OPTIONS_BY_HDTOOL_ID        = "activity-duibaHdtoolOptionsByHdtoolId_";
    public static final String KEY_DUIBA_NGAMR_BRICK_NO_CONTENT_BY_ID        = "activity-duibaNgameBrickNoContentById_";
    public static final String KEY_DUIBA_NGAMR_BRICK_CONTENT_BY_ID        = "activity-duibaNgameBrickContentById_";
    public static final String KEY_DUIBA_NGAMR_OPTIONS_BY_ID        = "activity-duibaNgameOptionsById_";
    public static final String KEY_DUIBA_NGAMR_BY_ID        = "activity-duibaNgameById_";
    public static final String KEY_DUIBA_SECONDS_KILL_ACTIVITY_BY_ID         = "activity-duibaSecondsKillActivityById_";
    public static final String KEY_DUIBA_QUIZZ_BY_ID         = "activity-duibaQuizzById_";
    public static final String KEY_HDTOOL_DEFAULT_SKIN_CACHE_KEY    = "activity-keyHdtoolDefaultSkinCacheKeyId_";
    public static final String KEY_HDTOOL_SKIN_CACHE_KEY = "activity-keyHdtoolSkinCacheKeyId_";
    public static final String KEY_SINGLE_LOTTERY_BY_ID ="activity-keySingleLotteryById_";
    public static final String KEY_OPERATING_ACTIVITY_BY_ID="activity-keyOperatingActivityById_";
    public static final String KEY_DUIBA_ACTIVITY_BY_ID="activity-keyDuibaActivityById_";
    public static final String KEY_OPERATING_ACTIVITY_OPTIONS_BY_ID="activity-keyOperatingActivityOptionsById_";
    public static final String KEY_OPERATING_ACTIVITY_OPTIONS_BY_OPERATING_ACTIVITY_ID="activity-keyOperatingActivityOptionsByOperatingActivityId_";
    public static final String KEY_DUIBA_SINGLE_LOTTERY_BY_ID="activity-keyDuibaSingleLotteryById_";
    public static final String KEY_DUIBA_SECKILL_ACT_BRICK_BY_ID="activity-keyDuibaSecKillActBrickById_";
    public static final String KEY_DUIBA_QUIZZ_BRICK_NO_CONTENT_BY_ID="activity-duibaQuizzBrickNoContentById_";
    public static final String KEY_DUIBA_QUIZZ_BRICK_CONTENT_BY_ID="activity-duibaQuizzBrickContentById_";
    public static final String KEY_DUIBA_QUIZZ_OPTIONS_BY_ID="activity-duibaQuizzOptionsById_";
    public static final String KEY_DUIBA_QUIZZ_OPTIONS_BY_QUIZZ_ID="activity-duibaQuizzOptionsByQuizzId_";
    //--- 20161018  chengdeman add  reason : littlegame皮肤缓存            ----start
    public static final String KEY_LITTLE_GAMR_BRICK_NO_CONTENT_BY_ID        = "activity-littleGameBrickNoContentById_";
    public static final String KEY_LITTLE_GAMR_BRICK_CONTENT_BY_ID        = "activity-littleGameBrickContentById_";
    //--- 20161018  chengdeman add  reason : littlegame皮肤缓存            ----end
    
    /**
     * 黑名单的缓存key
     */
    public static final String KEY_BLACK = "chaos.black_";


    // 不允许存在相同的静态常量,这里做判断,如果有相同的就抛出异常
    static {
        Field[] fields = CacheConstants.class.getFields();
        Set<String> set = new HashSet<String>();
        for (Field f : fields) {
            try {
                boolean success = set.add(f.get(null) + "_" + f.getType().getName());
                if (!success) {
                    throw new RuntimeException("duplicated value: [" + f.get(null) + "] ,please modify one of them");
                }
            } catch (IllegalAccessException e) {
                log.error("error:",e);
            }
        }
    }

}
