package cn.com.duiba.activity.center.biz.support;

import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * RedisKey 活动中心的所有获取key写到这里，避免key重复
 * 
 * @author houwen
 */
public class RedisKeyFactory {

	public static final String SPACE = "activity-center";

	public static String getConsumerJoinNumTodayKey(Long consumerId, Long operatingActivityId) {
		String today = new SimpleDateFormat("yyy-MM-dd").format(new Date());
		String key = SPACE + "joinNum" + today + consumerId.toString() + operatingActivityId.toString();
		return key;
	}

	public static String getConsumerJoinNumForeverKey(Long consumerId, Long operatingActivityId) {
		String key = SPACE + "joinNum" + consumerId.toString() + operatingActivityId.toString();
		return key;
	}

	public static String getConsumerFreeNumTodayKey(Long consumerId, Long operatingActivityId) {
		String today = new SimpleDateFormat("yyy-MM-dd").format(new Date());
		String key = SPACE + "freeNum" + today + consumerId.toString() + operatingActivityId.toString();
		return key;
	}

	public static String getConsumerFreeNumForeverKey(Long consumerId, Long operatingActivityId) {
		String key = SPACE + "freeNum" + consumerId.toString() + operatingActivityId.toString();
		return key;
	}

	public static String getConsumerWinOptionNumKey(Long consumerId, Long operatingActivityId, String optionId) {
		String key = SPACE + "winOptionNum" + consumerId.toString() + operatingActivityId.toString() + optionId;
		return key;
	}

}
