package cn.com.duiba.activity.common.center.api.msg.consumeraccount;

import cn.com.duiba.wolf.utils.GZIPUtils;
import com.alibaba.fastjson.JSONObject;

import java.io.Serializable;

/**
 * 提现完成回调
 * 接收消息通调用静态方法decode()获取回调对象
 * 通过调用isSuccess()判断是否提现成功
 * Created by hww on 2018/7/12 上午10:16.
 */
public class CashDrawResultMsg implements Serializable {

    private static final long serialVersionUID = -6980252038661702808L;

    /** 应用id */
    private Long appId;
    /** 用户id */
    private Long consumerId;
    /** 提现请求id */
    private Long orderId;
    /** 错误信息  提现失败才会有 */
    private String errorMsg;

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public Long getConsumerId() {
        return consumerId;
    }

    public void setConsumerId(Long consumerId) {
        this.consumerId = consumerId;
    }

    public Long getOrderId() {
        return orderId;
    }

    public void setOrderId(Long orderId) {
        this.orderId = orderId;
    }

    public String getErrorMsg() {
        return errorMsg;
    }

    public void setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
    }

    /**
     * 提现是否成功
     */
    public boolean isSuccess() {
        return errorMsg == null;
    }

    /**
     * 解码消息，接收mq消息使用
     *
     * @param msg
     * @return
     */
    public static CashDrawResultMsg decode(byte[] msg) {
        String string = GZIPUtils.ungzip(msg);
        if (string == null || string.isEmpty()) {
            return null;
        }
        return JSONObject.parseObject(string, CashDrawResultMsg.class);
    }

    /**
     * 编码消息，发送时使用
     *
     * @param msg
     * @return
     */
    public static byte[] encode(CashDrawResultMsg msg) {
        String string = JSONObject.toJSONString(msg);
        return GZIPUtils.gzip(string);
    }
}
