package cn.com.duiba.activity.common.center.api.remoteservice.operating;

import java.util.List;

import cn.com.duiba.activity.common.center.api.dto.activity.OperatingActivityDto;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

@AdvancedFeignClient
public interface RemoteOperatingActivityService {

	/**
	 * 
	 * findById:(这里用一句话描述这个方法的作用). <br/>
	 * 
	 * @param id
	 * @return
	 * @since JDK 1.6
	 */
	 OperatingActivityDto findById(Long id) throws BizException;
	
	
	/**
	 * 
	 * findByAppIdAndDuibaIdAndDeleted:(根据兑吧id  appId 活动类型 查询入库活动信息). <br/>
	 * 
	 * @param appId
	 * @param duibaId
	 * @param activityType
	 * @param deleted
	 * @return
	 * @since JDK 1.6
	 */
	 OperatingActivityDto findByAppIdAndDuibaIdAndDeleted(Long appId, Long duibaId,String activityType, Boolean deleted) throws BizException;

	/**
	 *
	 * activityAutoOff:(活动自动下线). <br/>
	 *
	 * @param activityIds
	 * @param activityType
	 * @param status
	 * @return
	 * @since JDK 1.6
	 */
	 List<Long> activityAutoOff(List<Long> activityIds, String activityType, Integer status) throws BizException;
}
