package cn.com.duiba.activity.common.center.api.enums.consumeraccounts;

/**
 * 用户账户变更业务类型
 * 变更账户余额的具体业务类型
 */
public enum AccountBizTypeEnum {

    BIZ_HD_TOOL_ACTIVITY("活动工具", 0),

    BIZ_PLUGIN_ACTIVITY("插件活动", 1),

    BIZ_CASH_DRAWS_PAY("提现支付", 2),

    BIZ_CASH_DRAWS_BACK("提现回滚", 3),

    LOGIN("登录加经验", 4),

    EXCHANGE("兑换", 5),

    ACTIVITY("参加活动", 6),

    PK_ACTIVITY("PK押注活动", 7),

    SEVEN_DAY_REWARD("七天红包", 8),

    PK_ACTIVITY_WALLET("PK押注活动钱包", 9),

    PK_ACTIVITY_EXPIRE("钱包过期", 10),

    SEED_RED_PACKET("种红包活动钱包", 11),
    ;

    AccountBizTypeEnum(String desc, Integer code) {
        this.code = code;
        this.desc = desc;
    }

    /** 描述 */
    private String desc;
    /** 类型码 */
    private Integer code;

    public String getDesc() {
        return desc;
    }

    public Integer getCode() {
        return code;
    }

}
