package cn.com.duiba.activity.common.center.api.aspect;

import cn.com.duiba.activity.common.center.api.config.ThirdPartyServiceNewConfig;
import cn.com.duiba.thirdparty.api.vnew.RemoteChargeService;
import cn.com.duiba.thirdparty.dto.SupplierRequestDto;
import com.alibaba.fastjson.JSON;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @author: pengyi
 * @description:
 * @date: 2023/3/9 上午10:28
 */
@Aspect
@Component
public class ThirdPartyServiceAspect {

    private static final Logger LOGGER = LoggerFactory.getLogger(ThirdPartyServiceAspect.class);

    @Autowired
    private ThirdPartyServiceNewConfig thirdPartyServiceNewConfig;

    @Pointcut("execution(* cn.com.duiba.thirdparty.api.RemoteChargeService.submitVirtual(..)))")
    public void virtualPointCut() {}

    public Object interceptThirdPartyRemote(ProceedingJoinPoint proceedingJoinPoint, RemoteChargeService remoteChargeService) throws Throwable {
        Object result;
        SupplierRequestDto supplierRequestDto = (SupplierRequestDto) proceedingJoinPoint.getArgs()[0];
        LOGGER.info("comm-center拦截参数，params={}", JSON.toJSONString(proceedingJoinPoint.getArgs()));
        // 获取appId，根据appId判断
        if (thirdPartyServiceNewConfig.getAppIds().contains(Long.valueOf(supplierRequestDto.getAppId()))) {
            LOGGER.info("comm-center转发到thirdparty-vnew");
            result = remoteChargeService.submitVirtual((SupplierRequestDto) proceedingJoinPoint.getArgs()[0], (String) proceedingJoinPoint.getArgs()[1], (String) proceedingJoinPoint.getArgs()[2], (String) proceedingJoinPoint.getArgs()[3]);
        } else {
            result = proceedingJoinPoint.proceed();
        }
        return result;
    }
}
