package cn.com.duiba.activity.custom.center.api.remoteservice.icbc;

import cn.com.duiba.activity.custom.center.api.dto.icbc.IcbcBankDto;
import cn.com.duiba.activity.custom.center.api.dto.icbc.IcbcTeamDto;
import cn.com.duiba.activity.custom.center.api.dto.icbc.IcbcUserDto;
import cn.com.duiba.activity.custom.center.api.dto.icbc.IcbcUserExcelDto;
import cn.com.duiba.activity.custom.center.api.params.icbc.IcbcUserParam;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

@AdvancedFeignClient
public interface RemoteIcbcAreaService {


    /**
     * 查询所有的一级行银行
     * @return
     */
    List<IcbcBankDto> selectLevelOneBank();

    /**
     * 通过ids查询银行
     * @param ids
     * @return
     */
    List<IcbcBankDto> selectByIds(List<Long> ids);

    /**
     * 通过parentIds查询
     * @return
     */
    List<IcbcBankDto> selectByParentIds(List<Long> parentIds);


    /**
     * 查询战队
     * @param bankId
     * @return
     */
    List<IcbcTeamDto> selectTeamByBankId(Long bankId);

    /**
     * teamIds查询战队
     *
     * @param teamIds
     * @return
     */
    List<IcbcTeamDto> selectByTeamIds(List<Long> teamIds);

    /**
     * 创建战队
     * @param icbcTeamDto
     * @return
     */
    Long insertTeam(IcbcTeamDto icbcTeamDto);


    /**
     * 查询战队数量
     * @param bankId
     * @return
     */
    Integer selectTeamCountByBankId(Long bankId);

    /**
     * 信息录入
     * @param icbcUserDto
     * @return
     */
    Long insertUserMessage(IcbcUserDto icbcUserDto);

    /**
     * 更新用户信息
     * @param icbcUserDto
     * @return
     */
    Integer updateUserMessage(IcbcUserDto icbcUserDto);

    /**
     * 查询用户信息
     * @param userId
     * @return
     */
    IcbcUserDto selectByUserId(Long userId);

    /**
     * 批量查询用户信息
     * @param userIds
     * @return
     */
    List<IcbcUserDto> selectByUserIds(List<Long> userIds);


    /**
     * 通过手机号查询用户
     * @param userPhones
     * @return
     */
    List<IcbcUserDto> selectUserByPhone(List<String> userPhones);


    /**
     * 插入银行信息
     * @param icbcBankDto
     * @return
     */
    Long insertBank(IcbcBankDto icbcBankDto);

    /**
     * 批量导入录入用户的信息
     * @param icbcUserParam
     * @return
     */
    List<IcbcUserExcelDto> exprotEntryUser(IcbcUserParam icbcUserParam);


}
