package cn.com.duiba.activity.custom.center.api.enums.questionnaire;

import java.util.Objects;

/**
 * @author haojiahong
 * @date 2020-05-27
 */
public enum QuestionnaireReleaseStatusEnum {
    INIT((byte) 0, "未投放"),
    RELEASING((byte) 1, "投放中"),
    RECOVERED((byte) 2, "已完成"),
    ;
    private Byte status;
    private String statusName;

    QuestionnaireReleaseStatusEnum(Byte status, String statusName) {
        this.status = status;
        this.statusName = statusName;
    }

    public Byte getStatus() {
        return status;
    }

    public String getStatusName() {
        return statusName;
    }

    public static QuestionnaireReleaseStatusEnum getByStatus(Byte status) {
        for (QuestionnaireReleaseStatusEnum value : QuestionnaireReleaseStatusEnum.values()) {
            if (Objects.equals(value.getStatus(), status)) {
                return value;
            }
        }
        return null;
    }
}
