package cn.com.duiba.activity.custom.center.api.enums.questionnaire;

import java.util.Objects;

/**
 * @author haojiahong
 * @date 2020-05-27
 */
public enum QuestionnaireStatusEnum {
    OFF((byte) 0, "下架"),
    ON((byte) 1, "上架"),
    ;

    private Byte status;
    private String statusName;

    QuestionnaireStatusEnum(Byte status, String statusName) {
        this.status = status;
        this.statusName = statusName;
    }

    public Byte getStatus() {
        return status;
    }

    public String getStatusName() {
        return statusName;
    }

    public static QuestionnaireStatusEnum getByStatus(Byte status) {
        for (QuestionnaireStatusEnum value : QuestionnaireStatusEnum.values()) {
            if (Objects.equals(status, value.getStatus())) {
                return value;
            }
        }
        return null;
    }

}
