package cn.com.duiba.activity.custom.center.api.enums.questionnaire;

import java.util.Objects;

/**
 * @author haojiahong
 * @date 2020-05-27
 */
public enum QuestionnaireTypeEnum {
    CREDITS_MALL((byte) 1, "积分商城"),
    ACTIVITY((byte) 2, "活动"),
    ;

    private Byte type;
    private String typeName;

    QuestionnaireTypeEnum(Byte type, String typeName) {
        this.type = type;
        this.typeName = typeName;
    }

    public Byte getType() {
        return type;
    }

    public String getTypeName() {
        return typeName;
    }

    public static QuestionnaireTypeEnum getByType(Byte type) {
        for (QuestionnaireTypeEnum value : QuestionnaireTypeEnum.values()) {
            if (Objects.equals(type, value.getType())) {
                return value;
            }
        }
        return null;
    }
}
