package cn.com.duiba.activity.custom.center.api.remoteservice.questionnaire;

import cn.com.duiba.activity.custom.center.api.dto.questionnaire.QuestionnaireAppDto;
import cn.com.duiba.activity.custom.center.api.dto.questionnaire.QuestionnaireKeyDto;
import cn.com.duiba.activity.custom.center.api.dto.questionnaire.answer.AppAnswerDto;
import cn.com.duiba.activity.custom.center.api.params.questionnaire.QuestionnaireAppQueryParam;
import cn.com.duiba.activity.custom.center.api.params.questionnaire.QuestionnaireAppStoreParam;
import cn.com.duiba.activity.custom.center.api.params.questionnaire.answer.AnswerPageParam;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * 调查问卷发放管理
 *
 * @author haojiahong
 * @date 2020-05-29
 */
@AdvancedFeignClient
public interface RemoteQuestionnaireReleaseService {

    /**
     * 根据条件查询发放列表
     *
     * @param param
     * @return
     */
    List<QuestionnaireAppDto> selectList(QuestionnaireAppQueryParam param);

    /**
     * 配合selectList使用，查询满足条件的记录数
     *
     * @param param
     * @return
     */
    int selectCount(QuestionnaireAppQueryParam param);

    /**
     * 通过id查询记录
     *
     * @param id
     * @return
     */
    QuestionnaireAppDto selectByPrimaryKey(Long id);


    /**
     * 根据id更新客户问卷信息
     *
     * @param pojo
     * @return
     */
    Integer updateById(QuestionnaireAppDto pojo);

    /**
     * 保存客户问卷信息
     *
     * @param param
     */
    void save(QuestionnaireAppStoreParam param);

    /**
     * 查询客户问卷答案信息
     *
     * @param questionnaireAppId
     * @return
     */
    List<AppAnswerDto> queryAnswer(Long questionnaireAppId);

    /**
     * 保存客户问卷答案
     *
     * @param param
     * @return
     */
    boolean saveAnswer(AnswerPageParam param);

    /**
     * Aes解密加密的问卷key
     *
     * @param key
     * @return
     */
    QuestionnaireKeyDto decodeKey(String key) throws BizException;

    /**
     * 生成与问卷关联的加密的key
     *
     * @param questionnaireAppId
     * @return
     */
    String generateKey(Long questionnaireAppId);

    /**
     * 加密id
     *
     * @param id
     * @return
     */
    String encryptId(Long id);

    /**
     * 解密id
     *
     * @param encryptedId
     * @return
     */
    Long decryptId(String encryptedId);

}
