package cn.com.duiba.activity.custom.center.api.remoteservice.ccb;

import cn.com.duiba.activity.custom.center.api.dto.ccb.ExchangeLimitCheckResultDto;
import cn.com.duiba.activity.custom.center.api.dto.ccb.ExchangeLimitConfigDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

/**
 * 活动维度控制兑换次数
 */
@AdvancedFeignClient
public interface RemoteExchangeLimitService {

    ExchangeLimitConfigDto getConfigByActivityId(Long activityId);

    ExchangeLimitConfigDto getConfigByAppItemId(Long appItemId);

    ExchangeLimitCheckResultDto check(ExchangeLimitConfigDto configDto, Long cid);

    boolean increase(Long appItemId, Long cid);

    boolean decrease(Long appItemId, Long cid);
}
